% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{mazGAMMA}
\alias{mazGAMMA}
\title{Gamma Distribution}
\usage{
mazGAMMA(r,c,l)
}
\arguments{
\item{r}{vector of moments.}

\item{c}{single value for shape parameter c.}

\item{l}{single value for shape parameter l.}
}
\value{
The output of \code{mazGAMMA} gives the moments about zero in vector form.
}
\description{
These functions provide the ability for generating probability density values,
cumulative probability density values and moment about zero values for
Gamma Distribution bounded between [0,1].
}
\details{
The probability density function and cumulative density function of a
unit bounded Gamma distribution with random variable P are given by

\deqn{g_{P}(p) = \frac{ c^l p^{c-1}}{\gamma(l)} [ln(1/p)]^{l-1} } ;    \eqn{0 \le p \le 1}
\deqn{G_{P}(p) = \frac{ Ig(l,cln(1/p))}{\gamma(l)} } ; \eqn{0 \le p \le 1}
\deqn{l,c > 0}

The mean the variance are denoted by
\deqn{E[P] = (\frac{c}{c+1})^l }
\deqn{var[P] = (\frac{c}{c+2})^l - (\frac{c}{c+1})^{2l} }

The moments about zero is denoted as
\deqn{E[P^r]=(\frac{c}{c+r})^l }
\eqn{r = 1,2,3,...}

Defined as \eqn{\gamma(l) } is the gamma function.
Defined as \eqn{Ig(l,cln(1/p))= \int_0^{cln(1/p)} t^{l-1} e^{-t}dt } is the Lower incomplete gamma function.


\strong{NOTE} : If input parameters are not in given domain  conditions necessary error
messages will be provided to go further.
}
\examples{
#plotting the random variables and probability values
col<-rainbow(4)
a<-c(1,2,5,10)
plot(0,0,main="Probability density graph",xlab="Random variable",ylab="Probability density values",
xlim = c(0,1),ylim = c(0,4))
for (i in 1:4)
{
lines(seq(0,1,by=0.01),dGAMMA(seq(0,1,by=0.01),a[i],a[i])$pdf,col = col[i])
}

dGAMMA(seq(0,1,by=0.01),5,6)$pdf   #extracting the pdf values
dGAMMA(seq(0,1,by=0.01),5,6)$mean  #extracting the mean
dGAMMA(seq(0,1,by=0.01),5,6)$var   #extracting the variance

#plotting the random variables and cumulative probability values
col<-rainbow(4)
a<-c(1,2,5,10)
plot(0,0,main="Cumulative density graph",xlab="Random variable",ylab="Cumulative density values",
xlim = c(0,1),ylim = c(0,1))
for (i in 1:4)
{
lines(seq(0,1,by=0.01),pGAMMA(seq(0,1,by=0.01),a[i],a[i]),col = col[i])
}

pGAMMA(seq(0,1,by=0.01),5,6)   #acquiring the cumulative probability values
mazGAMMA(1.4,5,6)              #acquiring the moment about zero values
mazGAMMA(2,5,6)-mazGAMMA(1,5,6)^2 #acquiring the variance for a=5,b=6

#only the integer value of moments is taken here because moments cannot be decimal
mazGAMMA(1.9,5.5,6)

}
\references{
Olshen, A. C. Transformations of the Pearson Type III Distribution.
Ann. Math. Statist. 9 (1938), no. 3, 176--200.
}
\seealso{
\code{\link[stats]{GammaDist}}
}
