% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiBin.R
\name{EstMLEMultiBin}
\alias{EstMLEMultiBin}
\title{Estimating the probability of success and theta for Multiplicative Binomial
Distribution}
\usage{
EstMLEMultiBin(x,freq,p,theta)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{p}{single value for probability of success.}

\item{theta}{single value for theta parameter.}
}
\value{
\code{EstMLEMultiBin} here is used as a input parameter for the \code{mle2} function of \pkg{bbmle} package
therefore output is of class of mle2.
}
\description{
The function will estimate the probability of success and theta parameter using the
maximum log likelihood method for the Multiplicative Binomial distribution when the binomial random
variables and corresponding frequencies are given.
}
\details{
\deqn{freq \ge 0}
\deqn{x = 0,1,2,..}
\deqn{0 < p < 1}
\deqn{0 < theta }
}
\examples{
No.D.D=0:7         #assigning the random variables
Obs.fre.1=c(47,54,43,40,40,41,39,95)    #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
parameters=suppressWarnings(bbmle::mle2(EstMLEMultiBin,start = list(p=0.5,theta=15),
           data = list(x=No.D.D,freq=Obs.fre.1)))

bbmle::coef(parameters)           #extracting the parameters

}
\references{
Johnson, N. L., Kemp, A. W., & Kotz, S. (2005). Univariate discrete distributions (Vol. 444).
Hoboken, NJ: Wiley-Interscience.

L. L. Kupper, J.K.H., 1978. The Use of a Correlated Binomial Model for the Analysis of Certain Toxicological
Experiments. Biometrics, 34(1), pp.69-76.

Paul, S.R., 1985. A three-parameter generalization of the binomial distribution. Communications in Statistics
- Theory and Methods, 14(6), pp.1497-1506.

Available at: \url{http://www.tandfonline.com/doi/abs/10.1080/03610928508828990} .
}
\seealso{
\code{\link[bbmle]{mle2}}
}
