% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_charts.R
\name{area_profiles}
\alias{area_profiles}
\title{Plot spine chart}
\usage{
area_profiles(data, value, count, area_code, local_area_code, indicator,
  timeperiod, polarity, significance, area_type, cols = "fingertips",
  median_line_area_code = "E92000001", comparator_area_code = NA,
  bar_width = 0.75, local_point_shape = 21,
  local_point_outline = "black", comparator_point_shape = 23,
  comparator_point_outline = "gray30",
  comparator_point_fill = "gray30", relative_point_size = 1,
  relative_text_size = 1, header_positions = c(-1.43, -0.53, -0.35,
  -0.25, -0.15, -0.05, 1.05), header_labels = c("Indicator",
  "Time\\nperiod", "Local\\ncount", "Local\\nvalue", "England\\nvalue",
  "Worst/\\nLowest", "Best/\\nHighest"), indicator_label_nudgex = -0.075,
  domain = no_domains, relative_domain_text_size = 1,
  show_dividers = "none", datatable = TRUE,
  datatable_line_height = 0.6, dps = 1, percent_display = 0.25)
}
\arguments{
\item{data}{a data frame to create the spine chart from. the data frame
should contain data for all area types included in the chart (eg, if
plotting for County & UA with a comparator of region and a median line for
national, the data frame should contain all of these data)}

\item{value}{unquoted field name containing the values to be plotted}

\item{count}{unquoted field name where the count (numerator) is stored}

\item{area_code}{unquoted field name where area codes are stored
(local_area_code, median_line_area_code and comparator_area_code, if using,
should all exist in this field)}

\item{local_area_code}{string; the code of the area that the spine chart is
being drawn for}

\item{indicator}{unquoted field name of the field containing the indicator
labels. Take care as errors will occur where indicator labels are the same
but data exist for multiple sub-categories (for example, sex or age)}

\item{timeperiod}{unquoted field name of the time period field}

\item{polarity}{unquoted field name containing the polarity information
(currently only handles polarity returned by fingertipsR package)}

\item{significance}{unquoted field name describing the statistical
significance for that indicator (eg, Better, Worse, Similar etc)}

\item{area_type}{unquoted field name containing area type information. This
ensures the vertabra are only plotted for the same area types as the
local_area area type (eg, when plotting a spine chart for County & UA
areas, regions and national area types will be removed)}

\item{cols}{named character vector for the cols that will be applied to the
significance field. The names should contain all of the levels in the
significance field of the data frame. Defaults to the Fingertips colours
based on the outputs from the API}

\item{median_line_area_code}{string; area code for the median line. Defaults
to "E92000001" (England)}

\item{comparator_area_code}{string; area code for the comparator point.
Defaults to NA}

\item{bar_width}{numeric value; the distance between bars (0 to 1)}

\item{local_point_shape}{numeric value; shape type for local area point
(defaults to 21, circle). See ggplot2 shape types for different values}

\item{local_point_outline}{string; control colour of the outline of the local
point in the spine chart}

\item{comparator_point_shape}{numeric value; shape type for regional area
point (defaults to 23, diamond). See ggplot2 shape types for different
values}

\item{comparator_point_outline}{string; control colour of the outline of the
regional point in the spine chart}

\item{comparator_point_fill}{string; control the fill colour of the regional
point in the spine chart}

\item{relative_point_size}{numeric value; control the size of the points on
the spine chart}

\item{relative_text_size}{numeric value; control the size of the text in the
accompanying table}

\item{header_positions}{numeric vector; used to adjust columns of data table
if they are overlapping. The final value shouldn't be less than 1. Must
have a length of 7. Defaults to c(-1.43, -.53, -.35, -.25, -.15, -0.05,
1.05)}

\item{header_labels}{character vector; labels used for the titles of the
columns for a data table. Must have a length of 7. Defaults to
c("Indicator", "Time period", "Local count","Local value", "England value",
"Worst/Lowest","Best/Highest")}

\item{indicator_label_nudgex}{number; nudge the placement of the indicator
label in the x direction. Negative values nudge to the left}

\item{domain}{unquoted field name describing the grouping of the domains if
wishing to split the spine chart into domains}

\item{relative_domain_text_size}{numeric; control the text size for the
domain labels (if include.domains = TRUE) relative to 1}

\item{show_dividers}{string; whether to display horizontal lines between
indicators. Values can be "all" or "outer". Any other value will not
generate lines}

\item{datatable}{logical; default = TRUE, display data table alongside spine
chart}

\item{datatable_line_height}{number; height of wrapped lines in the data
table}

\item{dps}{number; number of decimal places to be displayed in the data
table. The default is 1. Set to NA if this should be the same as the input
data}

\item{percent_display}{number between 0 and 1; the percentage of values that
needs to exist for a spine to display. Default is 0.25}
}
\value{
a ggplot object containing a spine chart
}
\description{
Returns ggplot of spine chart
}
\details{
the function draws a bar chart (which is the spine) and then plots
  the data table (if datatable = TRUE) using geom_text. The bar chart is
  always plotted between 0 and 1 on the x scale. The columns in the data
  table are controlled by the header_positions argument. To adjust the length
  of the bars in the visualisation, amend the header_positions argument. The
  more negative the first value of the vector that goes into
  header_positions, the more condensed the bar part of the visualisation will
  be.

This function filters for the area type that is the same as your
  local area type and then calculates the "vertebra" from those data.
  Therefore, if you are comparing outputs with those seen on the Fingertips
  website, ensure you perform the same preprocessing. For example, some
  profiles display spine charts where small areas, such as Isles of Scilly,
  are removed before the spine is produced.
}
\examples{
\donttest{
# This example is untested because of the time required to retrieve the data
library(fingertipsR)
library(dplyr)
df <- fingertips_data(DomainID = 1938133222, rank = TRUE) \%>\%
           filter(Timeperiod == "2016")
p <- area_profiles(df,
                   value = Value,
                   count = Count,
                   area_code = AreaCode,
                   local_area_code = "E06000020",
                   indicator = IndicatorName,
                   timeperiod = Timeperiod,
                   polarity = Polarity,
                   significance = ComparedtoEnglandvalueorpercentiles,
                   area_type = AreaType,
                   cols = "fingertips",
                   median_line_area_code = "E92000001",
                   comparator_area_code = "E12000005",
                   datatable = TRUE,
                   relative_domain_text_size = 0.75,
                   relative_text_size = 1.2,
                   bar_width = 0.68,
                   indicator_label_nudgex = -0.5)
p}

## or an example with differing decimal places for individual indicators

library(dplyr)
df <- create_test_data() \%>\%
mutate(Value = case_when(
        grepl("2$|4$|6$", IndicatorName) ~ round(Value,1),
        TRUE ~ round(Value, 0)))
full_p <- area_profiles(df,
                        value = Value,
                        count = Count,
                        area_code = AreaCode,
                        local_area_code = "AC122",
                        indicator = IndicatorName,
                        timeperiod = Timeperiod,
                        polarity = Polarity,
                        significance = Significance,
                        area_type = AreaType,
                        median_line_area_code = "C001",
                        comparator_area_code = "PAC12",
                        datatable = TRUE,
                        relative_domain_text_size = 0.75,
                        relative_text_size = 1.2,
                        bar_width = 0.68,
                        indicator_label_nudgex = -0.1,
                        show_dividers = "outer",
                        header_positions = c(-0.7, -0.44, -0.35, -0.25,
                                             -0.15, -0.05, 1.08),
                        dps = NA)
full_p

## or an example with domains and non-default indicator ordering

df <- create_test_data()
label_order <- c(1, 2, 4, 3, 6, 5)
df <- df \%>\%
        mutate(IndicatorName = factor(IndicatorName,
                                      levels = paste("Indicator", label_order)))

p <- area_profiles(df,
                   value = Value,
                   count = Count,
                   area_code = AreaCode,
                   local_area_code = "AC122",
                   indicator = IndicatorName,
                   timeperiod = Timeperiod,
                   polarity = Polarity,
                   significance = Significance,
                   area_type = AreaType,
                   median_line_area_code = "C001",
                   comparator_area_code = "PAC12",
                   datatable = TRUE,
                   relative_domain_text_size = 0.75,
                   relative_text_size = 1.2,
                   bar_width = 0.68,
                   indicator_label_nudgex = -0.1,
                   show_dividers = "outer",
                   header_positions = c(-0.7, -0.53, -0.35, -0.25,
                                        -0.15, -0.05, 1.05),
                   domain = Domain
)
p

}
