% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_charts.R
\name{trends}
\alias{trends}
\title{Plot trend chart}
\usage{
trends(
  data,
  timeperiod,
  value,
  area,
  comparator,
  area_name,
  fill,
  lowerci,
  upperci,
  title = "",
  subtitle = "",
  xlab = "",
  ylab = "",
  point_size = 4
)
}
\arguments{
\item{data}{data.frame object to plot using ggplot2 functions}

\item{timeperiod}{field containing the time period (unquoted)}

\item{value}{field containing variable to be plotted on x axis (unquoted)}

\item{area}{field containing variable to be plotted on y axis (unquoted)}

\item{comparator}{string; name of comparator area (this should exist in the
field described by the area parameter)}

\item{area_name}{string; name of the local area (this should exist in the
field described by the area parameter)}

\item{fill}{field to be used to determine the colouring of the bars (unquoted)}

\item{lowerci}{field containing variable to be plotted as lower confidence
interval (unquoted - not required)}

\item{upperci}{string; field containing variable to be plotted as upper confidence
interval (unquoted - not required)}

\item{title}{string; title of chart}

\item{subtitle}{string; text to use as subtitle to graph}

\item{xlab}{string; x-axis title}

\item{ylab}{string; y-axis title}

\item{point_size}{number; size of point}
}
\value{
a ggplot of trends for an indicator alongside a comparator
}
\description{
Plot trend chart
}
\examples{
library(dplyr)
df <- create_test_data()

df_trend <- df \%>\%
        arrange(IndicatorName) \%>\%
        mutate(Timeperiod = rep(c("2011", "2012", "2013", "2014", "2015", "2016"),
                                each = 111))
p <- trends(df_trend,
            timeperiod = Timeperiod,
            value = Value,
            area = AreaCode,
            comparator = "C001",
            area_name = "AC142",
            fill = Significance,
            lowerci = LCI,
            upperci = UCI,
            title = "Trend compared to country",
            subtitle = "For area AC142",
            xlab = "Year",
            ylab = "Value (\%)")
p
}
\seealso{
Other quick charts: 
\code{\link{box_plots}()},
\code{\link{compare_areas}()},
\code{\link{compare_indicators}()},
\code{\link{map}()},
\code{\link{overview}()},
\code{\link{population}()}
}
\concept{quick charts}
