% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_charts.R
\name{population}
\alias{population}
\title{Plot population pyramid}
\usage{
population(data, value, sex, age, area, area_name, comparator_1,
  comparator_2, title, subtitle, xlab)
}
\arguments{
\item{data}{data.frame object to plot using ggplot2 functions}

\item{value}{field containing variable to be plotted on x axis (unquoted)}

\item{sex}{field containing sex variable (unquoted)}

\item{age}{field containing age variable (unquoted)}

\item{area}{field containing variable to be plotted on y axis (unquoted)}

\item{area_name}{string; name of the local area (this should exist in the
field described by the area parameter)}

\item{comparator_1}{string; name of comparator area (this should exist in the
field described by the area parameter)}

\item{comparator_2}{string; name of comparator area (this should exist in the
field described by the area parameter)}

\item{title}{string; title of chart}

\item{subtitle}{string; text to use as subtitle to graph}

\item{xlab}{string; x-axis title}
}
\value{
a ggplot of a population pyramid against 2 optional comparators
}
\description{
Plot population pyramid
}
\examples{
library(dplyr)
agelevels <- c("0-4", "5-9","10-14","15-19",
               "20-24","25-29","30-34",
               "35-39","40-44","45-49",
               "50-54","55-59","60-64",
               "65-69","70-74","75-79",
               "80-84","85-89","90+")
areas <- c("Area 1", "Area 2", "Area 3")
pops <- data.frame(Age = factor(rep(agelevels, length(areas) * 2),
                                levels = agelevels),
                   Value = rep(sample(1000:3000, length(agelevels), replace = TRUE),
                               length(areas) * 2),
                   Sex = rep(rep(c("Male", "Female"),
                                 each = length(agelevels)), length(areas)),
                   AreaName = rep(areas, each = length(agelevels) * 2))

p <- population(pops,
                value = Value,
                sex = Sex,
                age = Age,
                area = AreaName,
                area_name = "Area 1",
                comparator_1 = "Area 3",
                comparator_2 = "Area 2",
                title = "Age Profile",
                subtitle = "2015/16",
                xlab = "\% of total population")
p
}
\seealso{
Other quick charts: \code{\link{box_plots}},
  \code{\link{compare_areas}},
  \code{\link{compare_indicators}}, \code{\link{map}},
  \code{\link{overview}}, \code{\link{trends}}
}
\concept{quick charts}
