% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_charts.R
\name{compare_areas}
\alias{compare_areas}
\title{Plot compare areas chart}
\usage{
compare_areas(data, area, value, lowerci, upperci, fill, order = "desc",
  top_areas, title = "", xlab = "", ylab = "",
  legend.position = "bottom")
}
\arguments{
\item{data}{data.frame object to plot using ggplot2 functions}

\item{area}{field containing variable to be plotted on y axis (unquoted)}

\item{value}{field containing variable to be plotted on x axis (unquoted)}

\item{lowerci}{field containing variable to be plotted as lower confidence
interval (unquoted - not required)}

\item{upperci}{string; field containing variable to be plotted as upper confidence
interval (unquoted - not required)}

\item{fill}{field to be used to determine the colouring of the bars (unquoted)}

\item{order}{one of "alphabetical", "asc" or "desc" - to determine how to
order the bars}

\item{top_areas}{character vector; the areas to fix at the top of the chart}

\item{title}{string; title of chart}

\item{xlab}{string; x-axis title}

\item{ylab}{string; y-axis title}

\item{legend.position}{the position of legends ("none", "left", "right",
"bottom", "top", or two-element numeric vector)}
}
\value{
a ggplot of a compare areas chart
}
\description{
Returns ggplot of compare areas chart
}
\examples{
library(fingertipsR)
library(dplyr)
region <- "South East region"
top_names <- c("England", region)
ordered_levels <- c("Better",
                    "Same",
                    "Worse",
                    "Not compared")
df <- fingertips_data(90316) \%>\%
        filter(is.na(CategoryType) &
                       Timeperiod == "2016/17" &
                       (AreaName \%in\% top_names |
                                ParentName == region) &
                       Sex == "Persons") \%>\%
        mutate(ComparedtoEnglandvalueorpercentiles =
                       factor(ComparedtoEnglandvalueorpercentiles,
                              levels = ordered_levels))
p <- compare_areas(df, AreaName, Value,
                   fill = ComparedtoEnglandvalueorpercentiles,
                   lowerci = LowerCI95.0limit,
                   upperci = UpperCI95.0limit,
                   order = "desc",
                   top_areas = top_names,
                   title = unique(df$IndicatorName))
p
}
\seealso{
Other quick charts: \code{\link{box_plots}},
  \code{\link{compare_indicators}}, \code{\link{map}},
  \code{\link{overview}}, \code{\link{population}},
  \code{\link{trends}}
}
