% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rcvr_data.R
\name{get_rcvr_data}
\alias{get_rcvr_data}
\title{Get A Dataframe of All Receiver Data from CalFishTrack}
\usage{
get_rcvr_data(fields = rcvr_fields)
}
\arguments{
\item{fields}{a vector of important field names to be imported from the
ERDDAP dataset}
}
\value{
A dataframe of receiver metadata which can be joined to detection data
}
\description{
This function searches the California Fish Tracking ERDAPP Database to create
a dataframe ofacoustic receiver metadata. Desired fields can be set to select
only certain fields, object rcvr_fields is the default. This data is used to add
receiver metadata to detection data in the add_fish function.
}
\examples{
# Retrieve the default set of fields from Cal Fish Track needed for package
tout <- getOption("timeout")
options(timeout = 4)
try(get_rcvr_data())
options(timeout = tout)
}
