% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.to.color.R
\name{string.to.colors}
\alias{string.to.color}
\alias{string.to.colors}
\alias{stringToColors}
\alias{stringtocolor}
\title{Convert between strings to colors}
\usage{
string.to.colors(string, colors = NULL)
}
\arguments{
\item{string}{a vector of strings representing groups.}

\item{colors}{a vector of colors, one for each unique element in \code{string}.}
}
\value{
a vector of colors, one for each element in \code{string}
}
\description{
Automatically convert a vector of strings into a color for easy plotting
}
\note{
This function can also be used to specify pch values, cex values, or any other plotting values
the user may wish to differ across groups. See examples.
}
\examples{
groups = sample(LETTERS[1:5], size=100, replace=TRUE)
plot(rnorm(100), rnorm(100), col=string.to.colors(groups))
plot(rnorm(100), rnorm(100), col=string.to.colors(groups), 
   pch=as.numeric(string.to.colors(groups, colors=c(16:20))))
}
\author{
Dustin Fife
}
\seealso{
\code{\link{number.to.colors}}
}

