%% $Id: x_Obj.Rd 42 2006-08-11 12:03:44Z bhm $
\encoding{latin1}
\name{x_Obj}
\alias{x_Obj}
\title{Creation of a design matrix object}
\description{
The function takes design/model information as input and performs initial computations for prediction and testing.
}
\usage{
x_Obj(D, model)
}

\arguments{
  \item{D}{A list containing a regressor matrix for each model term}
  \item{model}{The model coded as a matrix}
}

\details{
See the source code of \code{ffmanova} to see how \code{D} and  \code{model} are created.
}

\value{
\item{df_error}{degrees of freedom for error}
\item{D}{same as input}
\item{D_test}{as \code{D}, but with Type II* adjusted model terms. Will be used for testing.}
\item{D_om}{as \code{D}, but with OM-adjusted model terms. This is a non-overparameterised representation of the model. Will be used for prediction.}
\item{df_D_om}{degrees of freedom according to \code{D_om}}
\item{df_D_test}{degrees of freedom according to \code{D_test}}
\item{Beta_D}{output from \code{linregEst} where \code{D_om} is response and where \code{D} is regressor}
\item{VmodelDivS_D}{as above}
\item{VextraDivS1_D}{as above}
\item{Umodel}{output from \code{linregStart} where \code{D_om} is regressor}
\item{VmodelDivS}{as above}
\item{VextraDivS1}{as above}
\item{termNames}{model term names}
}

\author{yvind Langsrud and Bjrn-Helge Mevik}

\seealso{ 
  \code{\link{linregEst}},
  \code{\link{xy_Obj}}.
}

\keyword{models}
\keyword{design}
