% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_plot.R
\name{coef_plot}
\alias{coef_plot}
\title{Plots the coefficients of FERGM and ERGM objects.}
\usage{
coef_plot(fergm.fit = NULL, ergm.fit = NULL, custom_var_names = NULL)
}
\arguments{
\item{fergm.fit}{A model object returned by the \code{fergm} function.  Must be specified.}

\item{ergm.fit}{A model object returned by the \code{ergm} function.  May be specified when comparing ERGM and FERGM coefficients.}

\item{custom_var_names}{A vector of custom variable names used in presentation that match the order of the \code{form} object passed to \code{fergm}.  If not provided, defaults to names inherited by \code{fergm.fit}.}
}
\value{
This function produces a coefficient rope-ladder plot containing 95\% confidence intervals using ggplot2.  The function either takes \code{fergm} model output or \code{fergm} and \code{ergm} model output.  The former is effective in summarizing \code{fergm} model output while the latter is effective in comparing FERGM and ERGM estimates.
}
\description{
This function allows the users to visualize FERGM estimates or to compare the coefficients of ERGMs and FERGMs.
}
\examples{
# load example data
data("ergm.fit")
data("fergm.fit")
data("mesa")
# Compare substantive implications via coef plot, these are with 95\% credible intervals
coef_plot(fergm.fit = fergm.fit, ergm.fit = ergm.fit,
custom_var_names =  c("Edges", "Sex Homophily", "Grade Homophily",
"Race Homophily", "GWESP", "Alternating K-Stars"))
coef_plot(fergm.fit = fergm.fit,
custom_var_names =  c("Edges", "Sex Homophily", "Grade Homophily",
"Race Homophily", "GWESP", "Alternating K-Stars"))
}
\references{
Box-Steffensmeier, Janet M., Dino P. Christenson, and Jason W. Morgan. 2017. ``Modeling Unobserved Heterogeneity in Social Networks with the Frailty Exponential Random Graph Model." \emph{Political Analysis}.

Stan Development Team (2016). RStan: the R interface to Stan. R package version 2.14.1. \url{http://mc-stan.org/}.
}
\keyword{FERGM}
\keyword{interpret}
\keyword{summary}
