% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature.R
\name{FEATURESELECTION}
\alias{FEATURESELECTION}
\title{Classification with Feature selection}
\usage{
FEATURESELECTION(
  train,
  labels,
  algorithm = c("ranking", "forward", "backward", "exhaustive"),
  unieval = if (algorithm[1] == "ranking") c("fisher", "fstat", "relief", "inertiaratio")
    else NULL,
  uninb = NULL,
  unithreshold = NULL,
  multieval = if (algorithm[1] == "ranking") NULL else c("cfs", "fstat", "inertiaratio",
    "wrapper"),
  wrapmethod = NULL,
  mainmethod = wrapmethod,
  tune = FALSE,
  ...
)
}
\arguments{
\item{train}{The training set (description), as a \code{data.frame}.}

\item{labels}{Class labels of the training set (\code{vector} or \code{factor}).}

\item{algorithm}{The feature selection algorithm.}

\item{unieval}{The (univariate) evaluation criterion. \code{uninb}, \code{unithreshold} or \code{multieval} must be specified.}

\item{uninb}{The number of selected feature (univariate evaluation).}

\item{unithreshold}{The threshold for selecting feature (univariate evaluation).}

\item{multieval}{The (multivariate) evaluation criterion.}

\item{wrapmethod}{The classification method used for the wrapper evaluation.}

\item{mainmethod}{The final method used for data classification. If a wrapper evaluation is used, the same classification method should be used.}

\item{tune}{If true, the function returns paramters instead of a classification model.}

\item{...}{Other parameters.}
}
\description{
Apply a classification method after a subset of features has been selected.
}
\examples{
\dontrun{
require (datasets)
data (iris)
FEATURESELECTION (iris [, -5], iris [, 5], uninb = 2, mainmethod = LDA)
}
}
\seealso{
\code{\link{selectfeatures}}, \code{\link{predict.selection}}, \code{\link{selection-class}}
}
