% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_fct.R
\name{fct_group_by_prefix}
\alias{fct_group_by_prefix}
\title{Group Factor Levels by Common Prefix}
\usage{
fct_group_by_prefix(factor_vec, prefix_length)
}
\arguments{
\item{factor_vec}{A factor vector to be grouped.}

\item{prefix_length}{An integer specifying the number of characters in the prefix.}
}
\value{
A factor vector with levels grouped by the common prefix.
}
\description{
Groups factor levels by a common prefix of specified length.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple_red', 'apple_green', 'banana_yellow', 'banana_green', 'cherry_red'))

# Group by first 5 characters (common prefix)
fct_group_by_prefix(factor_vec, prefix_length = 5)
}
\author{
Kai Guo
}
