% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attach.R
\name{fastverse_extend}
\alias{fastverse_extend}
\title{Extend the fastverse}
\usage{
fastverse_extend(
  ...,
  topics = NULL,
  install = FALSE,
  permanent = FALSE,
  check.conflicts = !isTRUE(getOption("fastverse.quiet"))
)
}
\arguments{
\item{\dots}{comma-separated package names, quoted or unquoted, or vectors of package names.}

\item{topics}{integer or character. Short-keys to attach groups of related and packages suggested as extensions to the \emph{fastverse} (not case sensitive if character). Unavailable packages are skipped unless \code{install = TRUE}.
\enumerate{
\item \code{"TS"}: Time Series. Attaches \emph{xts}, \emph{zoo} and \emph{roll}. 
\item \code{"DT"}: Dates and Times. Attaches \emph{lubridate}, \emph{clock}, \emph{anytime}, \emph{fasttime} and \emph{timechange}.
\item \code{"ST"}: Strings. Attaches \emph{stringr}, \emph{stringi} and \emph{snakecase}.
\item \code{"SC"}: Statistics and Computing. Attaches \emph{Rfast}, \emph{Rfast2}, \emph{parallelDist} and \emph{coop}. % \emph{fastDummies}, 
\item \code{"SP"}: Spatial. Attaches \emph{sf}, \emph{stars} and \emph{terra}.
\item \code{"VI"}: Visualization. Attaches \emph{dygraphs}, \emph{ggplot2}, \emph{scales}, \emph{lattice} and \emph{grid}. % \emph{RColorBrewer} and \emph{viridis}.
\item \code{"TV"}: Tidyverse-Like. Attaches \emph{tidytable}, \emph{tidyfast}, \emph{tidyfst}, \emph{tidyft} and \emph{maditr}. % , \emph{table.express} and \emph{dtplyr}, import dplyr
}}

\item{install}{logical. Install packages not available?}

\item{permanent}{logical. Should packages be saved and included when \code{library(fastverse)} is called next time? Implemented via a config file saved to the package directory. The file will be removed if the \emph{fastverse} is reinstalled, and can be removed without reinstallation using \code{\link{fastverse_reset}}. Packages can be removed from the config file using \code{\link[=fastverse_detach]{fastverse_detach(..., permanent = TRUE)}}.}

\item{check.conflicts}{logical. Should conflicts between extension packages and attached packages be checked?}
}
\value{
This function returns nothing (\code{NULL} if assigned). Courtesy to CRAN maintainers, and because my name is not Hadley Wickham - who ostensibly is able to publish an entire \emph{tidyverse} package without these redundant statements.
}
\description{
Loads additional packages as part of the \emph{fastverse}. By default only for the session, but extensions can be saved up to reinstallation/updating of the \emph{fastverse} package.
}
\details{
The \emph{fastverse} can be extended using a free choice of packages, packages listed under \code{topics}, or a combination of both. If \code{install = FALSE}, only packages 
among the \code{topics} groups that are available are considered, others are disregarded. 

When the \emph{fastverse} is extended calling \code{fastverse_extend(...)}, the packages that are not attached are attached, but conflicts are checked for all specified packages. 
If \code{permanent = FALSE}, an \code{options("fastverse.extend")} is set which stores these extension packages, regardless of whether they were already attached or not. When calling 
\code{\link{fastverse_packages}}, \code{\link{fastverse_deps}}, \code{\link{fastverse_conflicts}}, \code{\link{fastverse_update}}, \code{\link{fastverse_sitrep}} or \code{\link{fastverse_detach}}, these packages are included as part of the \emph{fastverse}. 
This is also the case if \code{permanent = TRUE}, with the only difference that instead of populating the option, a file is saved to the package directory such that the packages are also loaded
(as part of the core \emph{fastverse}) when calling \code{library(fastverse)} in the next session. To extend the \emph{fastverse} for the current session when it is not yet loaded, users can also set \code{options(fastverse.extend = c(...))}, where \code{c(...)}
is a character vector of package names, before calling \code{library(fastverse)}.
}
\examples{
\donttest{
ex <- getOption("fastverse.extend")
fastverse_extend(xts, stringi)
fastverse_extend(fasttime, topics = "VI")

# Undoing this again
fastverse_detach(setdiff(getOption("fastverse.extend"), ex), session = TRUE)
rm(ex)
}
}
\seealso{
\code{\link{fastverse_detach}}, \code{\link{fastverse}}
}
