% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_models.R
\name{train_models}
\alias{train_models}
\title{Train Specified Machine Learning Algorithms on the Training Data}
\usage{
train_models(
  train_data,
  label,
  algorithms,
  resampling_method,
  folds,
  repeats = NULL,
  tune_params,
  metric,
  summaryFunction = NULL,
  seed = 123
)
}
\arguments{
\item{train_data}{Preprocessed training data frame.}

\item{label}{Name of the target variable.}

\item{algorithms}{Vector of algorithm names to train.}

\item{resampling_method}{Resampling method for cross-validation (e.g., "cv", "repeatedcv").}

\item{folds}{Number of folds for cross-validation.}

\item{repeats}{Number of times to repeat cross-validation (only applicable for methods like "repeatedcv").}

\item{tune_params}{List of hyperparameter tuning ranges.}

\item{metric}{The performance metric to optimize.}

\item{summaryFunction}{A custom summary function for model evaluation. Default is \code{NULL}.}

\item{seed}{An integer value specifying the random seed for reproducibility.}
}
\value{
A list of trained model objects.
}
\description{
Trains specified machine learning algorithms on the preprocessed training data.
}
