% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rWalkRast.r
\name{rWalkRast,GRaster-method}
\alias{rWalkRast,GRaster-method}
\alias{rWalkRast}
\title{Create raster representing one or more random walks}
\usage{
\S4method{rWalkRast}{GRaster}(
  x,
  n = 1,
  steps = 1e+05,
  directions = 8,
  avoid = FALSE,
  sameStart = FALSE,
  seed = NULL,
  check = TRUE
)
}
\arguments{
\item{x}{A \code{GRaster} to serve as a template.}

\item{n}{Numeric: Number of walkers. Default  is 1.}

\item{steps}{Numeric: Number of steps taken by each walker. Default is 100000.}

\item{directions}{Either 4 or 8: Directions in which a walker can turn at any point. If 4, then walks are confined to north/south/east/west directions (Rook's case). If 8, then the cardinal and subcardinal directions are allowed (Queen's case).}

\item{avoid}{Logical: If \code{FALSE} (default), then walkers can traverse their own walks. If \code{TRUE}, walkers avoid their own trails. A self-avoiding random walk can take much longer to compute.}

\item{sameStart}{Logical: If \code{FALSE} (default), walkers can begin anywhere. If \code{TRUE}, then walkers start from the same place.}

\item{seed}{Integer or \code{NULL} (default): If \code{NULL}, then a random seed is generated by the function. If numeric, results will be deterministic. In either case, the value will be rounded to the nearest integer.}

\item{check}{Logical: If \code{TRUE} (default), function will check to see if the addon \code{r.random.walk} has been installed. If it has not, it will attempt to install it.}
}
\value{
A \code{GRaster} with cell values representing the number of times one or more walkers traversed the cell.
}
\description{
This function creates a raster where the cell values represent the number of times one or more random "walkers" traverse the cell. If you simulate multiple random walkers, you can do computation in parallel, which can be controlled by allowing \strong{fasterRaster} to use multiple cores and more memory using the "cores" and "memory" arguments in the \code{\link[=faster]{faster()}} function.
}
\details{
This function needs the \strong{GRASS} addon \code{r.random.walk}. If it is not installed, it will try to install it.#'
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Elevation raster
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster:
elev <- fast(madElev)

### Create a raster with values drawn from a uniform distribution:
unif <- rUnifRast(elev)
plot(unif)

### Create a raster with values drawn from a normal distribution:
norms <- rNormRast(elev, n = 2, mu = c(5, 10), sigma = c(2, 1))
plot(norms)
hist(norms, bins = 100)

# Create a raster with random, seemingly normally-distributed values:
rand <- rSpatialDepRast(elev, dist = 1000)
plot(rand)

# Values appear normal on first inspection:
hist(rand)

# ... but actually are patterned:
hist(rand, bins = 100)

# Create a fractal raster:
fractal <- fractalRast(elev, n = 2, dimension = c(2.1, 2.8))
plot(fractal)
hist(fractal)

### Random walker rasters

# One random walker
walk <- rWalkRast(elev)
plot(walk)

# Random walker with self-avoidance:
walkAvoid <- rWalkRast(elev, steps = 1000, avoid = TRUE, seed = 1)
plot(walkAvoid)

# 10 random walkers:
walk10 <- rWalkRast(elev, n = 10)
plot(walk10)

# 10 random walkers starting in same place:
walkSame10 <- rWalkRast(elev, n = 10, sameStart = TRUE)
plot(walkSame10)


}
}
\seealso{
\code{\link[=rNormRast]{rNormRast()}}, \code{\link[=rUnifRast]{rUnifRast()}}, \code{\link[=rSpatialDepRast]{rSpatialDepRast()}}, \code{\link[=fractalRast]{fractalRast()}}
}
