% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance_estimation.R
\name{variance_mean}
\alias{variance_mean}
\alias{variance.mean}
\title{Variance estimation for mean change models}
\usage{
variance_mean(data)

variance.mean(data)
}
\arguments{
\item{data}{A matrix or a data frame with data points as each row.}
}
\value{
A matrix representing the variance-covariance matrix or a numeric
value representing the variance.
}
\description{
Implement Rice estimator.
}
\examples{
if (!requireNamespace("mvtnorm", quietly = TRUE)) utils::install.packages(
  "mvtnorm", repos = "https://cloud.r-project.org", quiet = TRUE
)

set.seed(1)
p <- 3
data <- rbind(
  mvtnorm::rmvnorm(300, mean = rep(0, p), sigma = diag(100, p)),
  mvtnorm::rmvnorm(400, mean = rep(50, p), sigma = diag(100, p)),
  mvtnorm::rmvnorm(300, mean = rep(2, p), sigma = diag(100, p))
)
(sigma <- variance.mean(data))
}
