% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.poisson_nmf_fit}
\alias{summary.poisson_nmf_fit}
\alias{summary.multinom_topic_model_fit}
\alias{print.summary.poisson_nmf_fit}
\alias{print.summary.multinom_topic_model_fit}
\title{Summarize Poisson NMF or Multinomial Topic Model Fit}
\usage{
\method{summary}{poisson_nmf_fit}(object, ...)

\method{summary}{multinom_topic_model_fit}(object, ...)

\method{print}{summary.poisson_nmf_fit}(x, show.mixprops = FALSE, show.topic.reps = FALSE, ...)

\method{print}{summary.multinom_topic_model_fit}(
  x,
  show.size.factors = FALSE,
  show.mixprops = FALSE,
  show.topic.reps = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \dQuote{poisson_nmf_fit} or
\dQuote{multinom_topic_model_fit}. The former is usually the result
of calling \code{\link{fit_poisson_nmf}}; the latter is usually the
result of calling \code{\link{fit_topic_model}} or
\code{\link{poisson2multinom}}.}

\item{\dots}{Additional arguments passed to the generic \code{summary}
or \code{print.summary} method.}

\item{x}{An object of class \dQuote{summary.poisson_nmf_fit},
usually a result of a call to \code{summary.poisson_nmf_fit}.}

\item{show.mixprops}{If \code{TRUE}, print a summary of the mixture
proportions.}

\item{show.topic.reps}{If \code{TRUE}, print a summary of the topic
representatives.}

\item{show.size.factors}{If \code{TRUE}, print a summary of the
size factors.}
}
\value{
The functions \code{summary.poisson_nmf_fit} and
\code{summary.multinom_topic_model_fit} compute and return a list
of statistics summarizing the model fit. The returned list
includes some or all of the following elements:

\item{n}{The number of rows in the counts matrix, typically the
  number of samples.}

\item{m}{The number of columns in the counts matrix, typically the
  number of observed counts per sample.}

\item{k}{The rank of the Poisson NMF or the number of topics.}

\item{s}{A vector of length n giving the "size factor" estimates;
  these estimates should be equal, or close to, the total counts in
  each row of the counts matrix.}

\item{numiter}{The number of loadings and/or factor updates
  performed.}

\item{loglik}{The Poisson NMF log-likelihood.}

\item{loglik.multinom}{The multinomial topic model log-likelihood.}

\item{dev}{The Poisson NMF deviance.}

\item{res}{The maximum residual of the Karush-Kuhn-Tucker (KKT)
  first-order optimality conditions. This can be used to assess
  convergence of the updates to a (local) solution.}

\item{mixprops}{Matrix giving a high-level summary of the
  mixture proportions, in which rows correspond to topics, and
  columns are ranges of mixture proportionss.}

\item{topic.reps}{A matrix in which the ith row gives the mixture
  proportions for the sample "most representative" of topic i; by
  "most representative", we mean the row (or sample) with the highest
  proportion of counts drawn from the topic i.}
}
\description{
\code{summary} method for the \dQuote{poisson_nmf_fit}
  and \dQuote{multinom_topic_model_fit} classes.
}
