% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_cutoffs.R
\name{all_cutoffs}
\alias{all_cutoffs}
\title{All cutoffs}
\usage{
all_cutoffs(x, grid_points = 101, fairness_metrics = fairness_check_metrics())
}
\arguments{
\item{x}{object of class \code{fairness_object}}

\item{grid_points}{numeric, grid for cutoffs to test. Number of points between 0 and 1 spread evenly}

\item{fairness_metrics}{character, name of metric or vector of multiple metrics names}
}
\value{
\code{all_cutoffs} object, \code{data.frame} containing information about label, metric and parity_loss at particular cutoff
}
\description{
Create \code{all_cutoffs} object and see how with the change of cutoffs parity loss of fairness metrics changes. Value of cutoff changes equally for all subgroups.
User can pick which fairness metrics to create the object with via fairness_metrics vector.
}
\examples{
data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           num.trees = 200)

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = german$Sex,
                          privileged = "male")


ac <- all_cutoffs(fobject,
                  fairness_metrics = c("TPR",
                                       "FPR"))
plot(ac)

}
