% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srh.posthoc.R
\name{srh.posthoc}
\alias{srh.posthoc}
\title{Dunn post hoc in a symmetric matrix form (one specified effect)}
\usage{
srh.posthoc(
  formula,
  data,
  method = "bonferroni",
  digits = 3,
  triangular = c("lower", "upper", "full"),
  numeric = FALSE,
  force_factors = TRUE,
  sep = "."
)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ factor} or \code{y ~ A + B}
(the latter is treated as \emph{one} combined grouping via interaction).}

\item{data}{A \code{data.frame} containing variables in \code{formula}.}

\item{method}{P-value adjustment method passed to \code{FSA::dunnTest()}.
Default \code{"bonferroni"}. See \code{p.adjust.methods} for options.}

\item{digits}{Number of digits for rounding in the returned matrices
when \code{numeric = FALSE}. Default \code{3}.}

\item{triangular}{Which triangle to show (\code{"lower"}, \code{"upper"},
or \code{"full"}). Default \code{"lower"}.}

\item{numeric}{Logical; if \code{TRUE}, return numeric matrices/data frames
with \code{NA} on the masked triangle/diagonal. If \code{FALSE} (default),
return character data frames with masked cells as empty strings.}

\item{force_factors}{Logical; coerce grouping variables to \code{factor}
(default \code{TRUE}).}

\item{sep}{Separator used in \code{interaction()} when combining factors.
Default \code{"."}.}
}
\value{
A list with three \code{data.frame}s:
\itemize{
\item \code{Z} – Z statistics,
\item \code{P.unadj} – unadjusted p-values,
\item \code{P.adj} – adjusted p-values (per \code{method}).
}
The original call is attached as attribute \code{"call"}.
}
\description{
Computes Dunn's rank-based pairwise comparisons for the effect implied by
\code{formula} and returns symmetric matrices for Z, unadjusted p-values,
and adjusted p-values. Cells on one triangle (or both) can be blanked for
compact reporting. For multi-factor RHS, factors are combined into a single
grouping via \code{interaction()} (e.g., \code{"A:B"} cells).
}
\details{
The function subsets to complete cases on \code{y} and RHS factors, optionally
coerces factors, builds a single grouping variable (\code{._grp}) and calls
\code{FSA::dunnTest(y ~ ._grp, data = ..., method = ...)}. The pairwise
results are placed into symmetric matrices \code{Z}, \code{P.unadj}, and
\code{P.adj}. By default only the lower triangle (excluding diagonal) is
shown for compactness.
}
\examples{
data(mimicry, package = "factorH")

# One factor
ph1 <- srh.posthoc(liking ~ condition, data = mimicry)
ph1$`P.adj`    # gotowa macierz p po korekcji

# Two factors combined (all A:B cells vs all A:B cells)
ph2 <- srh.posthoc(liking ~ gender + condition, data = mimicry)
ph2$`P.adj`

# Upper triangle, numeric frames
ph3 <- srh.posthoc(liking ~ condition, data = mimicry,
                   triangular = "upper", numeric = TRUE)
ph3$Z

}
