% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_change.R
\name{trace_change}
\alias{trace_change}
\title{Testing changes in the trace of the covariance operator in functional data}
\usage{
trace_change(fdobj, mean_change = FALSE, delta = 0.1, M = 1000)
}
\arguments{
\item{fdobj}{A functional data object of class '\code{fd}'}

\item{mean_change}{If \code{TRUE} then the data is centered considering the change in the mean function.}

\item{delta}{Trimming parameter to estimate the covariance function using partial sum estimates.}

\item{M}{Number of monte carlo simulations used to get the critical values. The default value is \code{M=1000}
value is \code{h=2}.}
}
\value{
\item{\code{pvalue}}{
Approximate p value for testing whether there is a significant change in the desired eigenvalue of the covariance operator
}
\item{\code{change}}{
Estimated change location
}
\item{\code{trace_before}}{
Estimated trace before the change
}
\item{\code{trace_after}}{
Estimated trace after the change
}
}
\description{
This function tests and detects changes in the trace of the covariance operator.
}
\details{
This function dates and detects changes in trace of the covariance function. This can be interpreted as the changes in
the total variation of the the functional data. Trace is defined as the infinite sum of the eigenvalues of the covariance operator
and for the sake of implementation purpose, the sum is truncated up to the total number of basis functions that defines the functional
data at hand. The critical values are approximated via \code{M} Monte Carlo simulations.
}
\examples{
# generate functional data
fdata = fun_IID(n=100, nbasis=21)
trace_change(fdata)
}
