% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{Pareto Distribution}
\alias{Pareto Distribution}
\alias{ppareto}
\alias{dpareto}
\alias{qpareto}
\alias{rpareto}
\title{Pareto distribution}
\usage{
ppareto(q, a = 1, loc = 0, scale = 1)

dpareto(x, a = 1, loc = 0, scale = 1)

qpareto(p, a = 1, loc = 0, scale = 1)

rpareto(n, a = 1, loc = 0, scale = 1)
}
\arguments{
\item{q}{a vector of quantiles.}

\item{a}{a vector of shape parameter of the Pareto distribution.}

\item{loc}{a vector of location parameter of the Pareto distribution.}

\item{scale}{a vector of scale parameter of the Pareto distribution.}

\item{x}{a vector of quantiles.}

\item{p}{a vector of probabilities.}

\item{n}{a number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
dpareto gives the density, ppareto gives the distribution function, qpareto gives the quantile function, and rpareto generates random deviates.

The length of the result is determined by n for rpareto, and is the maximum of the lengths of the numerical arguments for the other functions.

The numerical arguments other than n are recycled to the length of the result. Only the first elements of the logical arguments are used.
}
\description{
Density, distribution function, quantile function and random generation for the Pareto distribution where \eqn{a}, \eqn{loc} and \eqn{scale} are respectively the shape, the location and the scale parameters.
}
\details{
If \eqn{shape}, \eqn{loc} or \eqn{scale} parameters are not specified, the respective default values are \eqn{1}, \eqn{0} and \eqn{1}.

The cumulative Pareto distribution is
\deqn{
  F(x) = 1- ((x-loc)/scale) ^ {-a},  x > loc,  a > 0, scale > 0
}
where \eqn{a} is the shape of the distribution.

The density of the Pareto distribution is

\deqn{
  f(x) = (((x-loc)/scale)^( - a - 1) * a/scale) * (x-loc >= scale),  x > loc,  a > 0, scale > 0
}
}
\examples{
par(mfrow = c(3,1))
plot(function(x) dpareto(x), 1, 5,ylab="density",
     main = " Pareto density ")

plot(function(x) ppareto(x), 1, 5,ylab="distribution function",
     main = " Pareto Cumulative ")

plot(function(x) qpareto(x), 0, 1,ylab="quantile",
     main = " Pareto Quantile ")

#generate a sample of pareto distribution of size n
n <- 100
x <- rpareto(n)

}
