% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{predict.cox.adapt}
\alias{predict.cox.adapt}
\title{Predict the survival or quantile function from the extreme procedure for the Cox model}
\usage{
\method{predict}{cox.adapt}(object, newdata = NULL, input = NULL,
  type = "quantile", aggregation = "none", AggInd = object$kadapt,
  M = 10, ...)
}
\arguments{
\item{object}{output object of the function cox.adapt.}

\item{newdata}{a data frame with which to predict.}

\item{input}{optionnaly, the name of the variable to estimate.}

\item{type}{either "quantile" or "survival".}

\item{aggregation}{either "none", "simple" or "adaptive".}

\item{AggInd}{Indices of thresholds to be aggregated.}

\item{M}{Number of thresholds to be aggregated.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The function provide the quantile assiociated to the adaptive model for the probability grid if type = "quantile". And the survival function assiociated to the adaptive model for the quantile grid if type = "survival".
}
\description{
Give the survival or quantile function from the extreme procedure for the Cox model
}
\details{
\eqn{newdata} must be a data frame with the co-variables from which to predict and a variable of probabilities with its name starting with a "p" if type = "quantile" or a variable of quantiles with its name starting with a "x" if type = "survival".
The name of the variable from which to predict can also be written as \eqn{input}.
}
\examples{

library(survival)
data(bladder)

X <- bladder2$stop-bladder2$start
Z <- as.matrix(bladder2[, c(2:4, 8)])
delta <- bladder2$event

ord <- order(X)
X <- X[ord]
Z <- Z[ord,]
delta <- delta[ord]

cph<-coxph(Surv(X, delta) ~ Z)

ca <- cox.adapt(X, cph, delta, bladder2[ord,])

xgrid <- X
newdata <- as.data.frame(cbind(xgrid,bladder2[ord,]))

Plac <- predict(ca, newdata = newdata, type = "survival")
Treat <- predict(ca, newdata = newdata, type = "survival")

PlacSA <- predict(ca, newdata = newdata,
                          type = "survival", aggregation = "simple", AggInd = c(10,20,30,40))
TreatSA <- predict(ca, newdata = newdata,
                          type = "survival", aggregation = "simple", AggInd = c(10,20,30,40))


PlacAA <- predict(ca, newdata = newdata,
                          type = "survival", aggregation = "adaptive", M=10)
TreatAA <- predict(ca, newdata = newdata,
                          type = "survival", aggregation = "adaptive", M=10)

}
\seealso{
\code{\link{cox.adapt}}
}
