% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laplace-distribution.R
\name{Laplace}
\alias{Laplace}
\alias{dlaplace}
\alias{plaplace}
\alias{qlaplace}
\alias{rlaplace}
\title{Laplace distribution}
\usage{
dlaplace(x, mu = 0, sigma = 1, log = FALSE)

plaplace(q, mu = 0, sigma = 1, lower.tail = TRUE, log.p = FALSE)

qlaplace(p, mu = 0, sigma = 1, lower.tail = TRUE, log.p = FALSE)

rlaplace(n, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu, sigma}{location and scale parameters. Scale must be positive.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the Laplace distribution.
}
\details{
Probability density function
\deqn{
f(x) = \frac{1}{2\sigma} \exp\left(-\left|\frac{x-\mu}{\sigma}\right|\right)
}{
f(x) = 1/(2*\sigma) * exp(-|(x-\mu)/\sigma|)
}

Cumulative distribution function
\deqn{ F(x) = \left\{\begin{array}{ll}
\frac{1}{2} \exp\left(\frac{x-\mu}{\sigma}\right)     & x < \mu \\
1 - \frac{1}{2} \exp\left(\frac{x-\mu}{\sigma}\right) & x \geq \mu
\end{array}\right.
}{
F(x) = [if x < mu:] 1/2 * exp((x-\mu)/\sigma)
       [else:] 1 - 1/2 * exp((x-\mu)/\sigma)
}

Quantile function
\deqn{ F^{-1}(p) = \left\{\begin{array}{ll}
\mu + \sigma \log(2p)     & p < 0.5 \\
\mu - \sigma \log(2(1-p)) & p \geq 0.5
\end{array}\right.
}{
F^-1(p) = [if p < 0.5:] \mu + \sigma * log(2*p)
          [else:] \mu - \sigma * log(2*(1-p))
}
}
\examples{

x <- rlaplace(1e5, 5, 16)
hist(x, 100, freq = FALSE)
curve(dlaplace(x, 5, 16), -200, 200, n = 500, col = "red", add = TRUE)
hist(plaplace(x, 5, 16))
plot(ecdf(x))
curve(plaplace(x, 5, 16), -200, 200, n = 500, col = "red", lwd = 2, add = TRUE)

}
\references{
Krishnamoorthy, K. (2006). Handbook of Statistical Distributions
with Applications. Chapman & Hall/CRC

Forbes, C., Evans, M. Hastings, N., & Peacock, B. (2011).
Statistical Distributions. John Wiley & Sons.
}
\concept{
Univariate

Continuous
}
\keyword{distribution}
