% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchMark.R
\name{batchMarkUnmarkHmmLL}
\alias{batchMarkUnmarkHmmLL}
\title{Log-likelihood function for combined model.}
\usage{
batchMarkUnmarkHmmLL(
  par,
  data,
  Umax,
  nBins,
  choiceModel = c("model1", "model2", "model3", "model4"),
  cores
)
}
\arguments{
\item{par}{Initial values for the parameters to be optimized over.}

\item{data}{A capture-recapture data matrix or data frame.}

\item{Umax}{The maximum number of the unmarked individuals in the population for capture on any occasion.}

\item{nBins}{The number of bin size into which the matrix will be divided.}

\item{choiceModel}{This chooses among different models and allow for model selection.}

\item{cores}{The number of cores for parallelization.}
}
\value{
Negative Log-likelihood value of the likelihood function.
}
\description{
This helps users check whether the function can be optimized at the given initial values before optimizing using \code{\link{batchMarkUnmarkOptim}}. After a quick check, if \code{NAN} or \code{Inf} is returned, the initial values should be revisited.
}
\examples{
library(extBatchMarking)
theta <- c(0.1, 0.1, 7, -1.5)
res3  <- batchMarkUnmarkHmmLL(par        = theta,
                             data        = WeatherLoach,
                             choiceModel = "model4",
                             Umax        = 1800,
                             nBins       = 20,
                             cores       = 1)
res3
}
