% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchMarkfun.R
\name{batchMarkUnmarkOptim}
\alias{batchMarkUnmarkOptim}
\title{Combined Marked and Unmarked models.}
\usage{
batchMarkUnmarkOptim(
  par = NULL,
  data,
  choiceModel = c("model1", "model2", "model3", "model4"),
  method = c("Nelder-Mead", "BFGS", "CG", "L-BFGS-B"),
  Umax = 1800,
  nBins = 20,
  popSize = c("Horvitz_Thompson", "Model-Based"),
  parallel = FALSE,
  lowerBound = -Inf,
  cores = 1,
  hessian = FALSE,
  control,
  ...
)
}
\arguments{
\item{par}{Initial values for the parameters to be optimized over.}

\item{data}{A capture-recapture data matrix or data frame}

\item{choiceModel}{This chooses among different models and allow for model selection}

\item{method}{The method to be used. See optim for details.}

\item{Umax}{The maximum number of the unmarked individuals in the population for capture on any occasion.}

\item{nBins}{The number of bin size into which the matrix will be divided.}

\item{popSize}{The Horvitz_Thompson method or Model-Based to compute population size.}

\item{parallel}{Logical. Should the algorithm be run in parallel? This will be implemented in a future version.}

\item{lowerBound}{Lower bounds on the variables for the "L-BFGS-B" method.}

\item{cores}{The number of cores for parallelization}

\item{hessian}{Logical. Should a numerically differentiated Hessian matrix be returned?}

\item{control}{a list of control parameters. See \code{\link{optim}} for details.}

\item{...}{Further arguments to be passed by user which goes into the optim function.}
}
\value{
A list of the following optimized parameters will be returned.
\describe{
\item{phi}{The survival probability and remaining in the population between occasion t and t+1.}
\item{p}{The capture probability at occasion time t.}
\item{ll}{The optimized log-likelihood value of marked model.}
\item{hessian}{The hessian matrix.}
\item{AIC}{The Akaike Information Criteria for model selection.}
\item{lambda}{Initial mean abundance at occasion t = 1.}
\item{gam}{Recruitment rate of individual into the unmarked population.}
\item{M}{Total number of marked individual in the population.}
\item{U}{Total number of unmarked individuals in the population available for capture at occasion t = 1,..., T.}
\item{N}{Total population size at time t = 1, ..., T.}
}
}
\description{
batchMarkUnmarkOptim function provides the batch marking and unmarked function to be optimized.
}
\details{
Note that arguments after ... must be matched exactly.

batchMarkUnmarkOptim depends on optim function to optimize the parameters of the combined model. By default optim performs minimization.

Example on Umax and nBins: Umax = 1800 has a matrix of 1801 x 1801 and nBins = 20, reduces the matrix to 90 x 90. This is done in Cowen et al., 2017 to reduce the computing time when dealing with large matrix.
}
\examples{
# Load the package
library(extBatchMarking)

# Load the WeatherLoach data from Cowen et al., 2017.
data(WeatherLoach)

# Initial parameter values
theta <- c(0.1, 0.1, 7, -1.5)

\donttest{
mod1 <- batchMarkUnmarkOptim(
           par         = theta,
           data        = WeatherLoach,
           Umax        = 1800,
           nBins       = 20,
           choiceModel = "model4",
           popSize    = "Horvitz_Thompson",
           method      = "CG",
           parallel    = FALSE,
           control     = list(trace = 1))

 # Survival probability
 mod1$phi
 # Capture probability
 mod1$p
 # Optimized log-likelihood
 mod1$ll
 # The Hessian matrix
 mod1$hessian
 # The Aikaike Information Criteria
 mod1$AIC
 # The initial mean abundance
 mod1$lambda
 # Recruitment rate into the population
 mod1$gam
 # The estimated abundance of unmarked animals
 mod1$U
 # The estimated abundance of marked animals
 mod1$M
 # The estimated total abundance of marked and unmarked animals
 mod1$N
 }

 \donttest{
mod2 <- batchMarkUnmarkOptim(
           par         = theta,
           data        = WeatherLoach,
           Umax        = 1800,
           nBins       = 20,
           choiceModel = "model4",
           popSize    = "Model-Based",
           method      = "L-BFGS-B",
           parallel    = FALSE,
           control     = list(trace = 1))

 # Survival probability
 mod2$phi
 # Capture probability
 mod2$p
 # Optimized log-likelihood
 mod2$ll
 # The Hessian matrix
 mod2$hessian
 # The Akaike Information Criteria
 mod2$AIC
 # The initial mean abundance
 mod2$lambda
 # Recruitment rate into the population
 mod2$gam
 # The estimated abundance of unmarked animals
 mod2$U
 # The estimated abundance of marked animals
 mod2$M
 # The estimated total abundance of marked and unmarked animals
 mod2$N
 }
}
\references{
Laura L. E. Cowen, Panagiotis Besbeas, Byron J. T. Morgan, 2017.: Hidden Markov Models for Extended Batch Data,
Biometrics, 73, 1321-1331. DOI: 10.1111/biom.12701.
}
