% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fctr.R
\name{fctr}
\alias{fctr}
\title{Convert labelled variable to factor}
\usage{
fctr(x, ..., drop_unused_labels = FALSE, prepend_var_lab = TRUE)
}
\arguments{
\item{x}{a vector of data with labels.}

\item{...}{optional arguments for \code{\link[base]{factor}}}

\item{drop_unused_labels}{logical. Should we drop unused value labels?
Default is FALSE.}

\item{prepend_var_lab}{logical. Should we prepend variable label before value
labels? Default is TRUE.}
}
\value{
an object of class factor. For details see base \link[base]{factor} documentation.
}
\description{
\code{fctr} converts variable to factor. It force labels usage as factor 
labels for labelled variables even if 'expss.enable_value_labels_support' set
to 0. For other types of variables base \link[base]{factor} is called. Factor
levels are constructed as values labels. If label doesn't exist for
particular value then this value remain as is - so there is no information
lost. This levels look like as "Variable_label|Value label" if argument
\code{prepend} set to TRUE.
}
\examples{
data(mtcars)

var_lab(mtcars$am) = "Transmission"
val_lab(mtcars$am) = c(automatic = 0, manual=1)

summary(lm(mpg ~ am, data = mtcars)) # no labels  
summary(lm(mpg ~ fctr(am), data = mtcars)) # with labels 
summary(lm(mpg ~ fctr(unvr(am)), data = mtcars)) # without variable label 
}
\seealso{
\link{values2labels}, \link{names2labels}, \link{val_lab}, 
  \link{var_lab}. Materials for base functions: \code{\link[base]{factor}},
  \code{\link[base]{as.factor}}, \code{\link[base]{ordered}},
  \code{\link[base]{as.ordered}}
}
