% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_stats.R
\name{w_mean}
\alias{w_mean}
\alias{w_median}
\alias{w_var}
\alias{w_sd}
\alias{w_se}
\alias{w_mad}
\alias{w_sum}
\alias{w_n}
\alias{unweighted_valid_n}
\alias{valid_n}
\alias{w_max}
\alias{w_min}
\alias{w_cov}
\alias{w_cor}
\alias{w_pearson}
\alias{w_spearman}
\title{Compute various weighted statistics}
\usage{
w_mean(x, weight = NULL, na.rm = TRUE)

w_median(x, weight = NULL, na.rm = TRUE)

w_var(x, weight = NULL, na.rm = TRUE)

w_sd(x, weight = NULL, na.rm = TRUE)

w_se(x, weight = NULL, na.rm = TRUE)

w_mad(x, weight = NULL, na.rm = TRUE)

w_sum(x, weight = NULL, na.rm = TRUE)

w_n(x, weight = NULL, na.rm = TRUE)

unweighted_valid_n(x, weight = NULL)

valid_n(x, weight = NULL)

w_max(x, weight = NULL, na.rm = TRUE)

w_min(x, weight = NULL, na.rm = TRUE)

w_cov(x, weight = NULL, use = c("pairwise.complete.obs",
  "complete.obs"))

w_cor(x, weight = NULL, use = c("pairwise.complete.obs",
  "complete.obs"))

w_pearson(x, weight = NULL, use = c("pairwise.complete.obs",
  "complete.obs"))

w_spearman(x, weight = NULL, use = c("pairwise.complete.obs",
  "complete.obs"))
}
\arguments{
\item{x}{a numeric vector (matrix/data.frame for correlations) containing the
values whose weighted statistics is to be computed.}

\item{weight}{a vector of weights to use for each element of x. Cases with
missing, zero or negative weights will be removed before calculations. If
\code{weight} is missing then unweighted statistics will be computed.}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds. Note that contrary to base R statistic
functions the default value is TRUE (remove missing values).}

\item{use}{\code{"pairwise.complete.obs"} (default) or \code{"complete.obs"}.
In the first case  the correlation or covariance between each pair of
variables is computed using all complete pairs of observations on those
variables. If \code{use} is \code{"complete.obs"} then missing values are
handled by casewise deletion.}
}
\value{
a numeric value of length one/correlation matrix
}
\description{
\itemize{
\item{{\code{w_mean}}{ weighted mean of a numeric vector}}
\item{{\code{w_sd}}{ weighted sample standard deviation of a numeric vector}}
\item{{\code{w_var}}{ weighted sample variance of a numeric vector}}
\item{{\code{w_se}}{ weighted standard error of a numeric vector}}
\item{{\code{w_median}}{ weighted median of a numeric vector}}
\item{{\code{w_mad}}{ weighted mean absolute deviation from median of a numeric vector}}
\item{{\code{w_sum}}{ weighted sum of a numeric vector}}
\item{{\code{w_n}}{ weighted number of values of a numeric vector}}
\item{{\code{w_cov}}{ weighted covariance matrix of a numeric matrix/data.frame}}
\item{{\code{w_cor}}{ weighted Pearson correlation matrix of a numeric matrix/data.frame}}
\item{{\code{w_pearson}}{ shortcut for \code{w_cor}. Weighted Pearson
correlation matrix of a numeric matrix/data.frame}}
\item{{\code{w_spearman}}{ weighted Spearman correlation matrix of a numeric matrix/data.frame}}
}
}
\details{
If argument of correlation functions is data.frame with variable labels then
variables names will be replaced with labels. If this is undesirable behavior
use \link{unvr} function: \code{w_cor(unvr(x))}. Weighted spearman
correlation coefficients are calculated with rounded to nearest integer
weights. It gives the same result as in SPSS Statistics software. By now this
algorithm is not memory efficient.
}
\examples{
data(mtcars)
dfs = mtcars \%>\% keep(mpg, disp, hp, wt)

with(dfs, w_mean(hp, weight = 1/wt))

# apply labels
dfs = modify(dfs, {
         var_lab(mpg) = "Miles/(US) gallon"
         var_lab(disp) = "Displacement (cu.in.)"
         var_lab(hp) = "Gross horsepower"
         var_lab(wt) = "Weight (1000 lbs)"
})

# weighted correlations with labels
w_cor(dfs, weight = 1/dfs$wt)

# without labels
w_cor(unvr(dfs), weight = 1/dfs$wt)
}
