% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{explain_forest}
\alias{explain_forest}
\title{Explain a target using Random Forest.}
\usage{
explain_forest(data, target, ntree = 50, out = "plot", ...)
}
\arguments{
\item{data}{A dataset}

\item{target}{Target variable (binary)}

\item{ntree}{Number of trees used for Random Forest}

\item{out}{Output of the function: "plot" | "model" | "importance" | all"}

\item{...}{
  Arguments passed on to \code{\link[randomForest:randomForest]{randomForest::randomForest}}
  \describe{
    \item{\code{}}{}
  }}
}
\value{
Plot of importance (if out = "plot")
}
\description{
Explain a target using Random Forest.
}
\examples{
\dontshow{if (rlang::is_installed("randomForest")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

data <- create_data_buy()
explain_forest(data, target = buy)
\dontshow{\}) # examplesIf}
}
