% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i18n.R
\name{i18n_load}
\alias{i18n_load}
\title{Load translation dictionary}
\usage{
i18n_load(lang = "tr")
}
\arguments{
\item{lang}{Character scalar language code. Currently \code{"tr"} or \code{"en"}.}
}
\value{
A named list (key -> string) parsed from the JSON file.
}
\description{
Finds \verb{<lang>.json} under the installed package's \verb{i18n/} folder and,
if not found (during development), falls back to \verb{inst/i18n/<lang>.json}.
}
\examples{
# Always-fast: locate the installed TR dictionary (empty string if not installed)
system.file("shinyapp", "i18n", "tr.json", package = "examly")

# Safe example that runs only if the file actually exists
p <- system.file("shinyapp", "i18n", "tr.json", package = "examly")
if (nzchar(p) && file.exists(p)) {
  d <- i18n_load("tr")
  i18n_t(d, "ui.title", "Baslik")
}
}
