% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.evgam}
\alias{predict.evgam}
\title{Predictions from a fitted \code{evgam} object}
\usage{
\method{predict}{evgam}(
  object,
  newdata,
  type = "link",
  prob = NULL,
  se.fit = FALSE,
  marginal = TRUE,
  exi = TRUE,
  trace = 0,
  ...
)
}
\arguments{
\item{object}{a fitted \code{evgam} object}

\item{newdata}{a data frame}

\item{type}{a character string giving the type of prediction sought; see Details. Defaults to \code{"link"}}

\item{prob}{a scalar or vector of probabilities for quantiles to be estimated if \code{type == "quantile"}; defaults to 0.5}

\item{se.fit}{a logical: should estimated standard errors be returned? Defaults to \code{FALSE}}

\item{marginal}{a logical: should uncertainty estimates integrate out smoothing parameter uncertainty? Defaults to \code{TRUE}}

\item{exi}{a logical: if a dependent GEV is fitted should the independent parameters be returned? Defaults to \code{TRUE}}

\item{trace}{an integer where higher values give more output. -1 suppresses everything. Defaults to 0}

\item{...}{unused}
}
\value{
A data frame or list of predictions, or a plot if \code{type == "qqplot"}
}
\description{
Predictions from a fitted \code{evgam} object
}
\details{
There are five options for \code{type}: 1) \code{"link"} distribution parameters 
transformed to their model fitting scale; 2) \code{"response"} as 1), but on their 
original scale; 3) "lpmatrix" a list of design matrices; 4) "quantile"
estimates of distribution quantile(s); and 5) "qqplot" a quantile-quantile
plot.
}
\examples{

data(fremantle)
fmla_gev <- list(SeaLevel ~ s(Year, k=5, bs="cr"), ~ 1, ~ 1)
m_gev <- evgam(fmla_gev, fremantle, family = "gev")
# prediction of link GEV parameter for fremantle data
predict(m_gev)
# predictions for Year 1989
y1989 <- data.frame(Year = 1989)
# link GEV parameter predictions
predict(m_gev, y1989)
# GEV parameter predictions
predict(m_gev, y1989, type= "response")
# 10-year return level predictions
predict(m_gev, y1989, type= "quantile", prob = .9)
# 10- and 100-year return level predictions
predict(m_gev, y1989, type= "quantile", prob = c(.9, .99))

}
