% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{logLik}
\alias{logLik}
\alias{logLik.evgam}
\alias{AIC.evgam}
\alias{BIC.evgam}
\title{Log-likelihood, AIC and BIC from a fitted \code{evgam} object}
\usage{
\method{logLik}{evgam}(object, ...)

\method{AIC}{evgam}(object, ..., k = 2)

\method{BIC}{evgam}(object, ...)
}
\arguments{
\item{object}{a fitted \code{evgam} object}

\item{...}{not used}

\item{k}{numeric, the penalty per parameter to be used; the default \code{k = 2} is the classical AIC}
}
\value{
A scalar
}
\description{
Log-likelihood, AIC and BIC from a fitted \code{evgam} object
}
\examples{

\donttest{

library(evgam)
data(COprcp)
COprcp$year <- format(COprcp$date, "\%Y")
COprcp_gev <- aggregate(prcp ~ year + meta_row, COprcp, max)
COprcp_gev <- cbind(COprcp_gev, COprcp_meta[COprcp_gev$meta_row,])
fmla_gev <- list(prcp ~ s(lon, lat, k=30) + s(elev, bs="cr"), ~ s(lon, lat, k=20), ~ 1)
m_gev <- evgam(fmla_gev, data=COprcp_gev, family="gev")
logLik(m_gev)
AIC(m_gev)
BIC(m_gev)

}

}
