% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_body_attr.R
\name{get_body_attr}
\alias{get_body_attr}
\title{Get Event Body Attribute}
\usage{
get_body_attr(obj, attr)
}
\arguments{
\item{obj}{An event or a list of events.}

\item{attr}{A character string indicating the attribute to return.}
}
\value{
\code{get_body_attr()} returns a single attribute from an \code{event} or an \code{event_list} object.
}
\description{
This function returns an attribute or list of attributes from the body of an event or list of events.
}
\examples{

first_event <- event(
  id = 'first-event',
  type = 'FIRST_EVENT',
  time = Sys.time(),
  attr_01 = 'first-attribute-01'
)

second_event <- event(
  id = 'second-event',
  type = 'SECOND_EVENT',
  time = Sys.time(),
  attr_01 = 'first-attribute-02'
)

the_event_list <- event_list(first_event, second_event)

get_type(the_event_list)

}
