% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackknife-cuminc.R
\name{leaveOneOut.survival}
\alias{leaveOneOut.survival}
\title{Compute leave one out jackknife contributions of the survival function}
\usage{
leaveOneOut.survival(object, times, mr)
}
\arguments{
\item{object}{A survfit object, with a single event (no competing risks)}

\item{times}{Compute values at observed times up to and including this time}

\item{mr}{Model response, the result of a call to Surv, or a matrix with two columns: "time" (observed follow up time) and "status" (0 = censored, 1 = event)}
}
\value{
A vector of jackknifed values of survival at time times
}
\description{
For each subject, the survival function is recomputed leaving that subject out.
This one does the calculation for all observed times, for calculation of the restricted mean
}
\examples{

sfit.surv <- survival::survfit(survival::Surv(time, status) ~ 1, data = colon)
mrs <- with(colon, Surv(time, status))
jackvals <- leaveOneOut.survival(sfit.surv, 1000, mrs)
}
