% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GATE.R
\name{GATE}
\alias{GATE}
\title{Estimation of the Grouped Average Treatment Effects (GATEs) in Randomized Experiments}
\usage{
GATE(T, tau, Y, ngates = 5)
}
\arguments{
\item{T}{A vector of the unit-level binary treatment receipt variable for each sample.}

\item{tau}{A vector of the unit-level continuous score. Conditional Average Treatment Effect is one possible measure.}

\item{Y}{A vector of the outcome variable of interest for each sample.}

\item{ngates}{The number of groups to separate the data into. The groups are determined by \code{tau}. Default is 5.}
}
\value{
A list that contains the following items: \item{gate}{The estimated
vector of GATEs of length \code{ngates} arranged in order of increasing \code{tau}.} \item{sd}{The estimated vector of standard deviation
of GATEs.}
}
\description{
This function estimates the Grouped Average Treatment Effects (GATEs) where the groups are determined by a continuous score. The details of the methods for this design are given in Imai and Li (2022).
}
\examples{
T = c(1,0,1,0,1,0,1,0)
tau = c(0,0.1,0.2,0.3,0.4,0.5,0.6,0.7)
Y = c(4,5,0,2,4,1,-4,3)
gatelist <- GATE(T,tau,Y,ngates=5)
gatelist$gate
gatelist$sd
}
\references{
Imai and Li (2022). \dQuote{Statistical Inference for Heterogeneous Treatment Effects Discovered by Generic Machine Learning in Randomized Experiments},
}
\author{
Michael Lingzhi Li, Operations Research Center, Massachusetts Institute of Technology
\email{mlli@mit.edu}, \url{http://mlli.mit.edu};
}
\keyword{evaluation}
