% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_raw.R
\name{get_eurostat_raw}
\alias{get_eurostat_raw}
\title{Download Data from Eurostat Database}
\usage{
get_eurostat_raw(id)
}
\arguments{
\item{id}{A code name for the dataset of interested. See the table of
contents of eurostat datasets for more details.}
}
\value{
A dataset in tibble format. First column contains comma 
	  separated codes of cases. Other columns usually corresponds to 
  years and column names are years with preceding X. Data is in 
  character format as it contains values together with eurostat 
  flags for data.
}
\description{
Download data from the eurostat database.
}
\details{
Data is downloaded from
 \url{http://ec.europa.eu/eurostat/estat-navtree-portlet-prod/BulkDownloadListing} and transformed into tabular format.
}
\examples{
\dontrun{
	       tmp <- eurostat:::get_eurostat_raw("educ_iste")
	       head(tmp)
     }
}
\author{
Przemyslaw Biecek, Leo Lahti and Janne Huovari \email{ropengov-forum@googlegroups.com}
}
\references{
see citation("eurostat")
}
\seealso{
\code{\link{get_eurostat}}.
}
\keyword{database}
\keyword{utilities}

