<!-- README.md is generated from README.Rmd. Please edit that file -->

eulerr
======

<!-- badges: start -->

[![R build
status](https://github.com/jolars/eulerr/workflows/R-CMD-check/badge.svg)](https://github.com/jolars/eulerr/actions)
[![Coverage
Status](https://codecov.io/gh/jolars/eulerr/branch/master/graph/badge.svg)](https://codecov.io/gh/jolars/eulerr)
[![CRAN
Badge](http://www.r-pkg.org/badges/version/eulerr)](https://cran.r-project.org/package=eulerr)
<!-- badges: end -->

**eulerr** generates area-proportional Euler diagrams that display set
relationships (intersections, unions, and disjoints) with circles or
ellipses. [Euler diagrams](https://en.wikipedia.org/wiki/Euler_diagram)
are Venn diagrams without the requirement that all set interactions be
present (whether they are empty or not), which means that, depending on
input, **eulerr** sometimes produces Venn diagrams and sometimes not.

With three or more sets intersecting, exact Euler diagrams are often
impossible. For such cases **eulerr** attempts to provide a good
approximation by numerically tuning the parameters of the ellipses or
circles to minimize the error in the resulting diagram. Residuals and
goodness of fit statistics are provided to assess whether the resulting
diagram can be trusted.

Installation
------------

### CRAN version

    install.packages("eulerr")

### Development version

    devtools::install_github("jolars/eulerr")

### Shiny app

eulerr is also available as a shiny app hosted at
[eulerr.co](http://eulerr.co).

Usage
-----

    library(eulerr)
    # From Wilkinson 2012
    fit <- euler(c("A" = 4, "B" = 6, "C" = 3, "D" = 2, "E" = 7, "F" = 3,
                   "A&B" = 2, "A&F" = 2, "B&C" = 2, "B&D" = 1,
                   "B&F" = 2, "C&D" = 1, "D&E" = 1, "E&F" = 1,
                   "A&B&F" = 1, "B&C&D" = 1),
                 shape = "ellipse")

We can inspect the goodness-of-fit metrics *diagError* and *stress* for
the solution,

    fit$stress
    #> [1] 4.107279e-15
    fit$diagError
    #> [1] 1.010268e-08

and plot it

    plot(fit)

![](man/figures/README-plot_method-1.png)

Please see [the introductory
vignette](https://CRAN.R-project.org/package=eulerr/vignettes/introduction.html)
for a brief introduction or [*eulerr under the
hood*](https://CRAN.R-project.org/package=eulerr/vignettes/under-the-hood.html)
for details.

License
-------

eulerr is open source software, licensed under
[GPL-3](https://github.com/jolars/eulerr/blob/master/LICENSE).

Versioning
----------

eulerr uses [semantic versioning](https://semver.org).

Code of conduct
---------------

Please note that this project is released with a [Contributor Code of
Conduct](https://github.com/jolars/eulerr/blob/master/CONDUCT.md). By
participating in this project you agree to abide by its terms.

Acknowledgements
----------------

eulerr would not be possible without Ben Frederickson’s work on
[venn.js](http://www.benfrederickson.com) or Leland Wilkinson’s
[venneuler](https://cran.r-project.org/package=venneuler).
