% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rigid_M.R
\name{get.rigid.M}
\alias{get.rigid.M}
\title{Transfer matrix between two frames of reference}
\usage{
get.rigid.M(T.MAT, src.ref, dest.ref)
}
\arguments{
\item{T.MAT}{"t.mat" class object, created by the functions
\link[espadon]{load.patient.from.Rdcm}, \link[espadon]{load.patient.from.dicom}
or \link[espadon]{load.T.MAT}}

\item{src.ref}{Pseudonym of the source frame of reference}

\item{dest.ref}{Pseudonym of the destination frame of reference}
}
\value{
Returns the 4x4 transfer matrix \code{dest.ref} from \code{src.ref}.
}
\description{
The function \code{get.rigid.M} provides, from the T.MAT list created
by the functions \link[espadon]{load.patient.from.Rdcm},
\link[espadon]{load.patient.from.dicom} or \link[espadon]{load.T.MAT}, the 4x4
transfer matrix from the FoR (frame o reference) pseudonym \code{src.ref} to
the FoR pseudonym \code{dest.ref}.
}
\examples{
# loading of toy-patient objects
patient <- toy.load.patient (modality = c ("ct", "mr"), roi.name = "",
                             dxyz = c(5, 5, 5))
get.rigid.M (patient$T.MAT, "ref1", "ref2")
}
