% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_indices_from_roi.R
\name{rt.indices.from.roi}
\alias{rt.indices.from.roi}
\title{Dosimetry, volume, conformity, homogeneity indices from RoI
\loadmathjax}
\usage{
rt.indices.from.roi(
  vol,
  struct = NULL,
  T.MAT = NULL,
  target.roi.name = NULL,
  target.roi.sname = NULL,
  target.roi.idx = NULL,
  healthy.roi.name = NULL,
  healthy.roi.sname = NULL,
  healthy.roi.idx = NULL,
  presc.dose = NA,
  healthy.tol.dose = NA,
  healthy.weight = 1,
  dosimetry = c("D.min", "D.max", "D.mean", "STD"),
  volume.indices = c("V.tot", "area", "V.prescdose"),
  conformity.indices = c("PITV", "PDS", "CI.lomax2003", "CN", "NCI", "DSC",
    "CI.distance", "CI.abs_distance", "CDI", "CS3", "ULF", "OHTF", "gCI", "COIN",
    "G_COSI", "COSI"),
  homogeneity.indices = c("HI.RTOG.max_ref", "HI.RTOG.5_95", "HI.ICRU.max_min",
    "HI.ICRU.2.98_ref", "HI.ICRU.2.98_50", "HI.ICRU.5.95_ref", "HI.mayo2010",
    "HI.heufelder"),
  gradient.indices = c("GI.ratio.50", "mGI"),
  D.xpc = NULL,
  D.xcc = NULL,
  V.xpc = NULL,
  V.xGy = NULL,
  verbose = TRUE
)
}
\arguments{
\item{vol}{"volume" class object, of "rtdose" modality.}

\item{struct}{"struct" class object.}

\item{T.MAT}{"t.mat" class object, created by \link[espadon]{load.patient.from.Rdcm}
or  \link[espadon]{load.T.MAT}. If \code{T.MAT = NULL}, \code{struct$ref.pseudo}
must be equal to \code{vol$ref.pseudo}.}

\item{target.roi.name}{Exact name of target RoI in \code{struct} object.
By default \code{target.roi.name = NULL}. See Details.}

\item{target.roi.sname}{Name or part of name of target RoI in \code{struct}
object. By default \code{target.roi.sname = NULL}. See Details.}

\item{target.roi.idx}{Value of the index of target RoI that belong to the
\code{struct} object. By default \code{target.roi.idx = NULL}. See Details.}

\item{healthy.roi.name}{Exact name of healthy RoI in \code{struct} object.
By default \code{healthy.roi.name = NULL}.}

\item{healthy.roi.sname}{Name or part of name of healthy RoI in \code{struct}
object. By default \code{healthy.roi.sname = NULL}.}

\item{healthy.roi.idx}{Value of the index of healthy RoI that belong to the
\code{struct} object. By default \code{healthy.roi.idx = NULL}.}

\item{presc.dose}{Vector of prescription doses that serve as reference doses
for the target RoI.}

\item{healthy.tol.dose}{Vector of tolerance doses of each healthy RoI.}

\item{healthy.weight}{Vector of weights, indicating the importance of the
healthy RoI.}

\item{dosimetry}{Vector indicating the requested dose indicators from among
'D.min', 'D.max', 'D.mean' and 'STD.' If \code{D.xpc} is different from
\code{NULL}, it will be added.}

\item{volume.indices}{Vector indicating the requested volume indices from among
'V.tot',  'V.prescdose' (i.e. volume over \code{presc.dose}) and 'area'. If
\code{V.xGy} is different from \code{NULL}, it will be added.}

\item{conformity.indices}{Vector. Requested conformity indices from among 'PITV',
'PDS', 'CI.lomax2003', 'CN', 'NCI', 'DSC', 'CI.distance', 'CI.abs_distance',
'CDI', 'CS3', 'ULF', 'OHTF', 'gCI', 'COIN', 'COSI' and 'G_COSI'.}

\item{homogeneity.indices}{Vector. Requested homogeneity indices from among
'HI.RTOG.max_ref', 'HI.RTOG.5_95', 'HI.ICRU.max_min', 'HI.ICRU.2.98_ref',
'HI.ICRU.2.98_50', 'HI.ICRU.5.95_ref', 'HI.mayo2010' and 'HI.heufelder.'}

\item{gradient.indices}{Vector. Requested gradient indices from among
'GI.ratio.50', 'mGI'.}

\item{D.xpc}{Vector of the percentage of the volume, for which the dose coverage
is requested.}

\item{D.xcc}{Vector of the volume in \mjeqn{cm^3}{ascii}, for which the dose
coverage is requested.}

\item{V.xpc}{Vector of the percentage of the reference dose, received by the volume to be
calculated.}

\item{V.xGy}{Vector of the minimum dose in Gy, received by the volume to be
calculated.}

\item{verbose}{Boolean. if \code{TRUE} (default) a progress bar is displayed.}
}
\value{
Return  a list containing (if requested)

\mjeqn{-~dosimetry}{ascii} : dataframe containing, for all target and
healthy structures:
\itemize{
\item the requested \code{dosimetry} : \code{D.min} (Gy), \code{D.max} (Gy),
\code{D.mean} (Gy) and \code{STD} (Gy), respectively the minimum, maximum,
mean and standard deviation of the dose in the regions of interest.
\item the requested \code{$D.x\%} : (Gy) Dose covering x percent of structure volume.
\item the requested \code{$D.xcc} : (Gy) Dose covering x (\mjeqn{cm^3}{ascii})
of structure volume.
}

\mjeqn{-~volume}{ascii} : dataframe containing, for all target and
healthy structures, and isodoses:
\itemize{
\item the requested \code{volume.indices} : \code{V_tot} (\mjeqn{cm^3}{ascii})
(except for isodose) the total volume of the regions of interest, \code{area}
(\mjeqn{cm^2}{ascii}) (except for isodose) their surface areas,
\code{V.prescdose} (\mjeqn{cm^3}{ascii}) the volumes  receiving at least
\code{presc.dose} Gy,
\item the requested \code{V.xGy} (\mjeqn{cm^3}{ascii}):
volumes receiving at least x Gy.
\item the requested \code{V.xpc} (\mjeqn{cm^3}{ascii})
Volume receiving at least x\% of the reference dose.
}

\mjeqn{-~conformity}{ascii} : dataframe containing, if requested,
\itemize{
\item \code{PITV} : (1) Prescription Isodose Target Volume, or conformity index
defined by \emph{E.Shaw} \strong{[1]}
\mjdeqn{PITV = \frac{V_{presc.dose}}{V_{target}}}{ascii}
\item \code{PDS} : (1) Prescription Dose Spillage
defined by \emph{SABR UK Consortium 2019} \strong{[2]}
\mjdeqn{PDS = \frac{V_{presc.dose}}{V_{target ~\ge~ presc.dose}} = 
\frac{V_{presc.dose}}{V_{target} ~\cap~ V_{presc.dose}}}{ascii}
\item \code{CI.lomax2003} : (1) Conformity Index defined by \emph{Lomax and al}
\strong{[3]}
\mjdeqn{CI_{lomax2003} = \frac{V_{target ~\ge~ presc.dose}}{V_{presc.dose}} = 
\frac{V_{target} ~\cap~ V_{presc.dose}}{V_{presc.dose}}}{ascii}
\item \code{CN} : (1) Conformation Number defined by \emph{Van't Riet and al}
\strong{[4]}. It corresponds to conformity index defined by \emph{Paddick}
\strong{[5]}
\mjdeqn{CN = CI_{paddick2000} =\frac{V_{target ~\ge~ presc.dose}^2}{V_{target}~\cdot~V_{presc.dose}} = 
\frac{(V_{target} ~\cap~ V_{presc.dose})^2}{V_{target}~\cdot~V_{presc.dose}}}{ascii}
\item \code{NCI} : (1) New conformity index, inverse of CN, defined by
\emph{Nakamura and al} \strong{[6]}
\mjdeqn{NCI  =\frac{1}{CN}}{ascii}
\item \code{DSC} : (1) Dice Similarity Coefficient \strong{[7]}
\mjdeqn{DSC =  2 ~\cdot~\frac{V_{target ~\ge~ presc.dose}}{V_{target} + V_{presc.dose}} =
2 ~\cdot~\frac{V_{target} ~\cap~ V_{presc.dose}}{V_{target} + V_{presc.dose}}}{ascii}
\item \code{CI.distance} : (1) Conformity Index based on distance defined by
\emph{Park and al} \strong{[8]}
\mjdeqn{CI.distance = \frac{100}{N} \sum^N \frac{dist_{S_{presc.dose}~\to~G_{target}} - 
dist_{S_{target}~\to~G_{target}}}{dist_{S_{target}~\to~G_{target}}}}{ascii}
where \mjeqn{dist_{S_{presc.dose}~\to~G_{target}}}{ascii} is the distance between
the surface of the prescription dose volume and the centroid of the target,
and \mjeqn{dist_{S_{target}~\to~G_{target}}}{ascii} the surface of the target
volume and the centroid of the target.
\mjeqn{N}{ascii} is the number of directions where the distances are calculated.
These directions are computed every 1°. If the centroid is not within the target
volume, then \code{CI.distance = NA}.
\item \code{CI.abs_distance} : (1) Conformity Index based on distance defined
by \emph{Park and al} \strong{[8]}
\mjdeqn{CI.abs_distance = \frac{100}{N} \sum^N \frac{|dist_{S_{presc.dose}~\to~G_{target}} - 
dist_{S_{target}~\to~G_{target}}|}{dist_{S_{target}~\to~G_{target}}}}{ascii}
\item \code{CDI} : (1) Conformity Distance Index defined by \emph{Wu and al}
\strong{[9]}
\mjdeqn{CDI = 2 \frac{V_{presc.dose} + V_{target} - 2~V_{target ~\ge~ presc.dose}}
{S_{target} + S_{presc.dose}} = \frac{V_{presc.dose} + V_{target} - 2~\cdot~V_{target} ~\cap~ V_{presc.dose}}
{S_{target} + S_{presc.dose}}}{ascii}
where \mjeqn{S_{target}}{ascii} is the surface of the target volume and
\mjeqn{S_{presc.dose}}{ascii} is the surface of the prescription dose volume.
\item \code{CS3} : (1) Triple Point Conformity Scale defined by \emph{Ansari
and al} \strong{[10]}
\mjdeqn{CS3 = \frac{V_{0.95~\cdot~presc.dose} +  V_{presc.dose} +
 V_{1.05~\cdot~presc.dose}}{3~\cdot~V_{target}}}{ascii}
\item \code{ULF} : (1) Underdosed lesion factor defined by \emph{Lefkopoulos
and al} \strong{[11]}
\mjdeqn{ULF = \frac{V_{target ~<~ presc.dose}}{V_{target}}=
 \frac{V_{target} ~\cap~ \overline{V_{presc.dose}}}{V_{target}}}{ascii}
\item \code{OHTF} :(1) Overdosed healthy tissues factor defined by \emph{Lefkopoulos
and al} \strong{[11]}
\mjdeqn{OHTF = \frac{\sum V_{healthy ~\ge~ presc.dose}}{V_{target}} = 
\frac{\sum V_{healthy} ~\cap~ V_{presc.dose}}{V_{target}} }{ascii}
\item \code{gCI} : (1) Geometric Conformity Index  defined by
\emph{Lefkopoulos and al} \strong{[11]}
\mjdeqn{gCI = ULF + OHTF}{ascii}
\item \code{COIN} : Conformity Index defined by \emph{Baltas and al} \strong{[12]}
\mjdeqn{COIN  =\frac{V_{target ~\ge~ presc.dose}^2}{V_{target}~\cdot~V_{presc.dose}}~\cdot~
  \prod^{N_{healthy}} \left( 1 -\frac{V_{healthy ~\ge~ presc.dose}}{V_{healthy}}\right)}{ascii}
\item \code{gCOSI} : generalized COSI, defined by \emph{Menhel and al} \strong{[13]}.
\mjdeqn{gCOSI  = 1- \sum^{N_{healthy}}  healthy.weight~\cdot~
\frac{\frac{V_{healthy ~\ge~ healthy.tol.dose}}{V_{healthy}}}{\frac{V_{target ~\ge~ presc.dose}}{V_{target}}}}{ascii}
}

\mjeqn{-~COSI}{ascii} : if "COSI" is requested in \code{conformity.indices},
it returns a dataframe of Critical Organ Scoring Index for each healthy organ,
at each \code{presc.dose}, and for each target. COSI is defined by
\emph{Menhel and al} \strong{[13]}
\mjdeqn{COSI  = 1- 
\frac{\frac{V_{healthy ~\ge~ healthy.tol.dose}}{V_{healthy}}}{\frac{V_{target ~\ge~ presc.dose}}{V_{target}}}}{ascii}

\mjeqn{-~homogeneity}{ascii} : dataframe containing
\itemize{
\item \code{HI.RTOG.max_ref} : (1) Homogeneity Index from RTOG defined by
\emph{E.Shaw} \strong{[1]}
\mjdeqn{HI.RTOG.max_-ref = \frac{D_{~max}}{presc.dose}}{ascii}
where \mjeqn{D_{max}}{ascii} is the maximum dose in the target volume.
\item \code{HI.RTOG.5_95} : (1) Homogeneity Index from RTOG \strong{[1]}
\mjdeqn{HI.RTOG.5_-95 = \frac{D.5pc}{D.95pc}}{ascii}
where \mjeqn{D.5pc}{ascii} and \mjeqn{D.95pc}{ascii} are respectively the doses
at 5\% and 95\% of the target volume in cumulative dose-volume histogram.
\item \code{HI.ICRU.max_min} : (1) Homogeneity Index from \emph{ICRU report 62}
\strong{[14]}
\mjdeqn{HI.ICRU.max_-min = \frac{D_{~max}}{D_{~min}}}{ascii}
where \mjeqn{D_{max}}{ascii} and \mjeqn{D_{min}}{ascii} are respectively the
maximum and the minimum dose in the target volume.
\item \code{HI.ICRU.2.98_ref} : (1) Homogeneity Index from \emph{ICRU report 83}
\strong{[15]}
\mjdeqn{HI.ICRU.2.98_-ref = 100 \frac{D.2pc - D.98pc}{presc.dose}}{ascii}
where \mjeqn{D.2pc}{ascii} and \mjeqn{D.98pc}{ascii} are respectively the doses
at 2\% and 98\% of the target volume in cumulative dose-volume histogram.
\item \code{HI.ICRU.2.98_50 } : (1) Homogeneity Index from \emph{ICRU report 83}
\strong{[15]}
\mjdeqn{HI.ICRU.2.98_-50 = 100 \frac{D.2pc - D.98pc}{D.50pc}}{ascii}
where \mjeqn{D.2pc}{ascii}, \mjeqn{D.98pc}{ascii} and \mjeqn{D.50pc}{ascii} are
respectively the doses
at 2\%, 98\% and 50\% of the target volume in cumulative dose-volume histogram.
\item \code{HI.ICRU.5.95_ref} : (1) Homogeneity Index from \emph{ICRU report 83}
\strong{[15]}
\mjdeqn{HI.ICRU.5.95_-ref = 100 \frac{D.5pc - D.95pc}{presc.dose}}{ascii}
where \mjeqn{D.5pc}{ascii} and \mjeqn{D.95pc}{ascii} are respectively the doses
at 5\% and 95\% of the target volume in cumulative dose-volume histogram.
\item \code{HI.mayo2010} : (1) Homogeneity Index defined by \emph{Mayo and al}
\strong{[16]}
\mjdeqn{HI.mayo2010 =\sqrt{\frac{D_{~max}}{presc.dose}~\cdot~(1 + 
\frac{\sigma_D}{presc.dose})}}{ascii}
where \mjeqn{D_{max}}{ascii} is the maximum dose in the target volume, and
\mjeqn{\sigma_D}{ascii} the standard deviation of the dose in the target volume.
\item \code{HI.heufelder} : (1) Homogeneity Index defined by \emph{Heufelder and al}
\strong{[17]}
\mjdeqn{HI.heufelder = e^{-0.01~\cdot~ (1-\frac{\mu_D}{presc.dose})^2}~\cdot~
e^{-0.01~\cdot~ (\frac{\sigma_D}{presc.dose})^2}}{ascii}
where \mjeqn{\mu_D}{ascii} and \mjeqn{\sigma_D}{ascii} are
respectively the mean and the standard deviation of the dose in the target volume.
}

\mjeqn{-~gradient}{ascii} : dataframe containing
\itemize{
\item \code{GI.ratio.50}: Gradient Index based on volumes ratio defined by
\emph{Paddick and Lippitz} \strong{[18]}
\mjdeqn{GI.ratio.50 = \frac {V_{0.5~\cdot~presc.dose}}{V_{presc.dose}}}{ascii}
\item \code{mGI}: Modified Gradient Index defined by \emph{SABR UK Consortium 2019}
\strong{[2]}
\mjdeqn{mGI = \frac{V_{0.5~\cdot~presc.dose}}{V_{target ~\ge~ presc.dose}} = 
\frac{V_{0.5~\cdot~presc.dose}}{V_{target} ~\cap~ V_{presc.dose}}}{ascii}
}
}
\description{
The \code{rt.indices.from.roi} function calculates, from a "volume"
class object of modality "rtdose", standard indicators of radiotherapy
in relation to the target and healthy RoI, as long as their options are transmitted.
}
\details{
If \code{target.roi.name}, \code{target.roi.sname}, and
\code{target.roi.idx} are all set to \code{NULL}, all RoI containing 'ptv'
(if they exist) are selected.

If \code{target.roi.name}, \code{target.roi.sname}, and \code{target.roi.idx}
are all set to \code{NULL},no target RoI are selected.

If \code{healthy.roi.name}, \code{healthy.roi.sname}, and
\code{healthy.roi.idx} are all set to \code{NULL}, no healthy RoI are selected.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb 
#  for better result)
step <- 5
patient <- toy.load.patient (modality = c("rtdose", "rtstruct"), roi.name = "eye",
                             dxyz = rep (step, 3), beam.nb = 3)
indices <- rt.indices.from.roi (patient$rtdose[[1]],  patient$rtstruct[[1]],
                                target.roi.sname = "ptv",
                                healthy.roi.sname = "eye", presc.dose = 50,
                                conformity.indices = c("PITV", "PDS", "CI.lomax2003", 
                                                       "CN", "NCI", "DSC","COIN"),
                                verbose = FALSE)
indices
}
\references{
\strong{[1]} \insertRef{SHAW19931231}{espadon}

\strong{[2]} \insertRef{SABR}{espadon}

\strong{[3]} \insertRef{LOMAX20031409}{espadon}

\strong{[4]} \insertRef{RIET1997731}{espadon}

\strong{[5]} \insertRef{Paddick2000ASS}{espadon}

\strong{[6]} \insertRef{Nakamura2002}{espadon}

\strong{[7]} \insertRef{DICE1945}{espadon}

\strong{[8]} \insertRef{Park2014}{espadon}

\strong{[9]} \insertRef{Wu2003}{espadon}

\strong{[10]} \insertRef{Ansari2018}{espadon}

\strong{[11]} \insertRef{LEFKOPOULOS2000}{espadon}

\strong{[12]} \insertRef{Baltas1998ACI}{espadon}

\strong{[13]} \insertRef{Menhel2006}{espadon}

\strong{[14]} \insertRef{ICRU621}{espadon}

\strong{[15]} \insertRef{ICRU83}{espadon}

\strong{[16]} \insertRef{MAYO20101457}{espadon}

\strong{[17]} \insertRef{HEUFELDER2003231}{espadon}

\strong{[18]} \insertRef{Paddick2006ASD}{espadon}

All this references are compiled by
\itemize{
\item \insertRef{KAPLAN2021164}{espadon} and
\item \insertRef{PATEL2020}{espadon}.
}
}
\seealso{
\link[espadon]{rt.indices.from.bin}.
}
