% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_erosion.R
\name{bin.erosion}
\alias{bin.erosion}
\title{Binary volume erosion}
\usage{
bin.erosion(vol, radius = 10, alias = "", description = NULL)
}
\arguments{
\item{vol}{"volume" class object, of \code{"binary"} modality}

\item{radius}{Positive number, in millimeters. By default, radius = 10.}

\item{alias}{Character string, \code{$object.alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL} (default value), it will be set to
\code{paste (vol$object.alias, "erosion r =", radius)}.}
}
\value{
Returns a "volume" class object of \code{"binary"} modality (see
\link[espadon]{espadon.class} for class definitions), with the same grid as
\code{vol}, in which the selected volume has been reduced
by the \code{radius}.
}
\description{
The \code{bin.erosion} function decreases a
"volume" class object, of \code{"binary"} modality, by means of
convolution with a sphere.
Erosion is useful for :
\itemize{
\item removing volumes that are smaller than the \code{radius},
\item eliminating narrow capes,
\item enlarging  channels,
\item turning  peninsulas into islands.
}
}
\note{
Erosion can be time consuming, try to reduce the \code{binary}
volume to the strict minimum, before any operations.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = "mr", roi.name = "", 
                             dxyz = rep (step, 3))
MR <- patient$mr[[1]]

# generation of a binary volume
b <- bin.from.vol(MR, min = 15,max = 30)

b.erosion <- bin.erosion (b, radius = step)
display.plane (bottom = MR, top = b, main = "Before erosion", 
               view.coord = -20, interpolate = FALSE)
display.plane (bottom = MR, top = b.erosion, main = "After erosion", 
               view.coord = -20, interpolate = FALSE)
}
\seealso{
\link[espadon]{bin.dilation}, \link[espadon]{bin.opening},
\link[espadon]{bin.closing}, \link[espadon]{add.margin}, \link[espadon]{nesting.cube}.
}
