% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct_clustering.R
\name{struct.clustering}
\alias{struct.clustering}
\title{Clustering volumes by RoI
\loadmathjax}
\usage{
struct.clustering(
  vol,
  struct,
  roi.name = NULL,
  roi.sname = NULL,
  roi.idx = NULL,
  T.MAT = NULL,
  alias = "",
  description = NULL,
  verbose = TRUE
)
}
\arguments{
\item{vol}{"volume" class object.}

\item{struct}{"struct" class object.}

\item{roi.name}{Vector of exact names of the RoI in the \code{struct} object.
By default \code{roi.name = NULL}. See Details.}

\item{roi.sname}{Vector of names or parts of names of the RoI in the \code{struct} object.
By default \code{roi.sname = NULL}. See Details.}

\item{roi.idx}{Vector of indices of the RoI that belong to the \code{struct} object.
By default \code{roi.idx = NULL}. See Details.}

\item{T.MAT}{"t.mat" class object, created by
\link[espadon]{load.patient.from.Rdcm} or \link[espadon]{load.T.MAT}. If
\code{T.MAT = NULL}, \code{struct$ref.pseudo} must be equal to
\code{vol$ref.pseudo}.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL} (default value), it will be set to
\code{paste (struct$object.alias,"clustering")}}

\item{verbose}{Boolean. if \code{TRUE} (default), the RoI studied are listed.}
}
\value{
Returns a "volume" class object (see \link[espadon]{espadon.class}
for class definitions), of \code{"cluster"} modality. This object contains the
\code{$cluster.info} field, detailing the label and volumes in \mjeqn{cm^{3}}{ascii}
of the different clusters. Note that the label \code{NA} or value 0 is used for the voxels
which are not contained in any RoI (air for instance).
}
\description{
The \code{struct.clustering} function creates a new volume
in which voxels are clustered and labeled by region of interest defined in an
rt-struct.
}
\details{
If \code{roi.name}, \code{roi.sname}, and \code{roi.idx} are
all set to \code{NULL}, all RoI are selected.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 5
patient <- toy.load.patient (modality = c ("mr", "rtstruct"),  
                             dxyz = rep (step, 3))
MR <- patient$mr[[1]]
S <- patient$rtstruct[[1]]
cluster.vol <- struct.clustering (MR, S, T.MAT = patient$T.MAT, verbose = FALSE)
head (cluster.vol$cluster.info)

# Display
n = nrow(cluster.vol$cluster.info)
col = c ("#00000000", rainbow (n))
breaks <- seq (0, n, length.out = n+2)

display.plane (cluster.vol, main = "RoI clustering", view.coord = 0, 
               bottom.col = col, bottom.breaks = breaks, interpolate = FALSE)

}
\seealso{
\link[espadon]{get.roi.connection}
}
