% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_T_MAT.R
\name{save.T.MAT}
\alias{save.T.MAT}
\title{Save a T.MAT class object}
\usage{
save.T.MAT(T.MAT, dirname)
}
\arguments{
\item{T.MAT}{"t.mat" class object to save.}

\item{dirname}{Directory where new reg .Rdcm files will be saved.}
}
\value{
Returns \code{TRUE}, if all reg files generating T.MAT are saved.
}
\description{
The \code{save.T.MAT} function saves the data required by
\link[espadon]{load.T.MAT}, \link[espadon]{load.patient.from.dicom} or
\link[espadon]{load.patient.from.Rdcm} to generate \code{T.MAT}, as
pre-formatted Rdcm files.
}
\details{
Reg files from DICOM files cannot be updated with the \code{save.T.MAT}
function. Only transfer matrices added with \link[espadon]{ref.add} or
\link[espadon]{ref.cutplane.add} will be saved.
}
\examples{
# loading of toy-patient objects (decrease dxyz for  better result)
step <- 5
patient <- toy.load.patient (modality = c("ct", "mr"), roi.name = "", 
                             dxyz = rep (step, 3))
                             
# Save T.MAT to a temporary file pat.dir
pat.dir <- file.path (tempdir(), "PM_Rdcm") 
dir.create (pat.dir, recursive = TRUE) 
save.T.MAT (patient$T.MAT, dirname = pat.dir)
list.files(pat.dir)

# Cleaning  temporary directory
unlink (pat.dir, recursive = TRUE)
}
