% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_inversion.R
\name{bin.inversion}
\alias{bin.inversion}
\title{Inversion of a binary}
\usage{
bin.inversion(vol, alias = "", description = NULL)
}
\arguments{
\item{vol}{"volume" class object, of "binary" modality}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL} (default value), it will be set to
\code{paste ("!", vol$object.alias, sep = "")}.}
}
\value{
Returns a "volume" class object of "binary" modality (see
\link[espadon]{espadon.class} for class definitions), with the same grid as
\code{vol}, inverse of \code{vol}.
}
\description{
The \code{bin.inversion} function creates a "volume" class object,
of "binary" modality, representing the inverse (logical \code{NOT}) of another binary object.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = c("ct", "rtstruct"), roi.name = "", 
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]
S <- patient$rtstruct[[1]]

bin.patient <- bin.from.roi (CT, struct = S, roi.name = c ("patient"),
                             alias = "patient")
inverse.patient <- bin.inversion (bin.patient, alias = "inv (patient)")

display.plane(CT, top = inverse.patient, interpolate = FALSE)
}
