% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{b1twostar-ergmTerm}
\alias{b1twostar-ergmTerm}
\alias{InitErgmTerm.b1twostar}
\title{Two-star census for central nodes centered on the first mode of a bipartite network}
\usage{
# binary: b1twostar(b1attr, b2attr, base=NULL, b1levels=NULL, b2levels=NULL, levels2=NULL)
}
\arguments{
\item{b1attr}{b1 nodes (actors in some contexts) (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details)}

\item{b2attr}{b2 nodes (events in some contexts). If \code{b2attr} is not passed, it is assumed to be the same as \code{b1attr} .}

\item{b1levels, b2levels, base, levels2}{used to leave some of the categories out (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details)}
}
\description{
This term takes two nodal attributes. Assuming that there are
\eqn{n_1} values of \code{b1attr} among the b1 nodes and \eqn{n_2}
values of \code{b2attr} among the b2 nodes, then the total number of
distinct categories of two stars according to these two attributes is
\eqn{n_1(n_2)(n_2+1)/2}. By default, this model term creates a distinct statistic
counting each of these categories.
}
\note{
The argument \code{base} is retained for backwards compatibility and may be
removed in a future version. When both \code{base} and \code{levels} are passed,
\code{levels} overrides \code{base}.

The argument \code{base} is retained for backwards compatibility and may be
removed in a future version. When both \code{base} and \code{levels2} are passed,
\code{levels2} overrides \code{base}.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b1twostar", "subsection")}
}
\concept{bipartite}
\concept{categorical nodal attribute}
\concept{undirected}
