% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.geodistn.R
\name{ergm.geodistdist}
\alias{ergm.geodistdist}
\alias{ergm.geodistn}
\title{Calculate geodesic distance distribution for a network or edgelist}
\usage{
ergm.geodistdist(nw, directed = is.directed(nw))

ergm.geodistn(edgelist, n = max(edgelist), directed = FALSE)
}
\arguments{
\item{nw}{\code{\link[network:network]{network}} object over which distances should be
calculated}

\item{directed}{logical, should the network be treated as directed}

\item{edgelist}{an edgelist representation of a network as an mx2 matrix}

\item{n}{integer, size of the network}
}
\value{
a vector \code{ans} with length equal to the size of the network
where \itemize{
\item \verb{ans[i], i=1, ..., n-1} is the number of pairs of
geodesic length \code{i}
\item \code{ans[n]} is the number of pairs of geodesic length
infinity.  }
}
\description{
\code{ergm.geodistdist} calculates geodesic distance distribution for a
given \code{\link[network:network]{network}} and returns it as a vector.

\code{ergm.geodistn} calculates geodesic deistance
distribution based on an input edgelist, and has very little
error checking so should not normally be called by users. The C
code requires the edgelist to be directed and sorted correctly.
}
\details{
\code{ergm.geodistdist} is a network wrapper for \code{ergm.geodistn}, which
calculates and returns the geodesic distance distribution for a given
network via full_geodesic_distribution.C
}
\examples{

data(faux.mesa.high)
ergm.geodistdist(faux.mesa.high)

}
\seealso{
See also the sna package \code{\link[sna:geodist]{geodist()}} function
}
\keyword{internal}
