% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{gwdsp-ergmTerm}
\alias{gwdsp-ergmTerm}
\alias{InitErgmTerm.gwdsp}
\title{Geometrically weighted dyadwise shared partner distribution}
\usage{
# binary: gwdsp(decay, fixed=FALSE, cutoff=30)
}
\arguments{
\item{decay}{nonnegative decay parameter for the shared partner or directed 2-path count; required if \code{fixed=TRUE} and ignored with a warning otherwise.}

\item{fixed}{optional argument indicating
whether the \code{decay} parameter is fixed at the given value, or is to be fit as a curved
exponential-family model (see Hunter and Handcock, 2006). The
default is \code{FALSE} , which means the scale parameter is not
fixed and thus the model is a curved exponential family.}

\item{cutoff}{This optional argument sets the number of underlying DSP terms
to use in computing the statistics when \code{fixed=FALSE}, in order to reduce
the computational burden.  Its default value can also be controlled by the
\code{gw.cutoff} term option control parameter. (See \code{?control.ergm}.)}
}
\description{
This term adds one network statistic to the model equal to the geometrically
weighted dyadwise shared partner distribution with decay parameter
\code{decay} parameter, which should be non-negative.
This term can be used with directed and undirected networks.
}
\note{
This term takes an additional term option (see
\code{\link[=ergm-options]{options?ergm}}), \code{cache.sp}, controlling whether
the implementation will cache the number of shared partners for
each dyad in the network; this is usually enabled by default.

For directed networks, only outgoing two-path ("OTP") shared partners
are counted.  In other words, for a (directed) dyad \verb{(i,j)} in a directed graph, the number of
shared partners counted by \code{gwdsp} is the number of nodes \code{k} that have edges
\code{i -> k -> j}.  (These may also be called homogeneous shared partners.)  To
count other types of shared partners instead, see \code{dgwdsp}.

The \code{decay} parameter was called \code{alpha} prior to \code{ergm} 3.7.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "gwdsp", "subsection")}
}
\concept{curved}
\concept{directed}
\concept{undirected}
