% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.san.R
\name{control.san}
\alias{control.san}
\title{Auxiliary for Controlling SAN}
\usage{
control.san(
  SAN.maxit = 4,
  SAN.tau = 1,
  SAN.invcov = NULL,
  SAN.invcov.diag = FALSE,
  SAN.nsteps.alloc = function(nsim) 2^seq_len(nsim),
  SAN.nsteps = 2^19,
  SAN.samplesize = 2^12,
  SAN.prop = trim_env(~sparse),
  SAN.prop.weights = "default",
  SAN.prop.args = list(),
  SAN.packagenames = c(),
  SAN.ignore.finite.offsets = TRUE,
  term.options = list(),
  seed = NULL,
  parallel = 0,
  parallel.type = NULL,
  parallel.version.check = TRUE,
  parallel.inherit.MT = FALSE
)
}
\arguments{
\item{SAN.maxit}{Number of temperature levels to use.}

\item{SAN.tau}{Tuning parameter, specifying the temperature of the
process during the \emph{penultimate} iteration. (During the last
iteration, the temperature is set to 0, resulting in a greedy
search, and during the previous iterations, the temperature is
set to \verb{SAN.tau*(iterations left after this one)}.}

\item{SAN.invcov}{Initial inverse covariance matrix used to
calculate Mahalanobis distance in determining how far a proposed
MCMC move is from the \code{target.stats} vector.  If \code{NULL},
initially set to the identity matrix. In either case, during
subsequent runs, it is estimated empirically.}

\item{SAN.invcov.diag}{Whether to only use the diagonal of the
covariance matrix. It seems to work better in practice.}

\item{SAN.nsteps.alloc}{Either a numeric vector or a function of
the number of runs giving a sequence of relative lengths of
simulated annealing runs.}

\item{SAN.nsteps}{Number of MCMC proposals for all the annealing runs combined.}

\item{SAN.samplesize}{Number of realisations' statistics to obtain for tuning purposes.}

\item{SAN.prop}{Specifies the proposal (directly) and/or
a series of "hints" about the structure of the model being
sampled. The specification is in the form of a one-sided formula
with hints separated by \code{+} operations. If the LHS exists and is
a string, the proposal to be used is selected directly.

A common and default "hint" is \code{~sparse}, indicating
that the network is sparse and that the sample should put roughly
equal weight on selecting a dyad with or without a tie as a
candidate for toggling.}

\item{SAN.prop.weights}{Specifies the proposal
distribution used in the SAN Metropolis-Hastings algorithm.  Possible
choices depending on selected \code{reference} and \code{constraints}
arguments of the \code{\link[=ergm]{ergm()}} function, but often include \code{"TNT"}
and \code{"random"}, and the \code{"default"} is to use the one with the
highest priority available.}

\item{SAN.prop.args}{An alternative, direct way of
specifying additional arguments to proposal.}

\item{SAN.packagenames}{Names of packages in which to look for change
statistic functions in addition to those autodetected. This argument should
not be needed outside of very strange setups.}

\item{SAN.ignore.finite.offsets}{Whether SAN should ignore (treat as 0) finite offsets.}

\item{term.options}{A list of additional arguments to be passed to term initializers. See \code{\link[=term.options]{? term.options}}.}

\item{seed}{Seed value (integer) for the random number generator.  See
\code{\link[base]{set.seed}}.}

\item{parallel}{Number of threads in which to run the sampling. Defaults to
0 (no parallelism). See the entry on \link[=ergm-parallel]{parallel processing}
for details and troubleshooting.}

\item{parallel.type}{API to use for parallel processing. Supported values
are \code{"MPI"} and \code{"PSOCK"}. Defaults to using the \code{parallel}
package with PSOCK clusters. See \code{\link{ergm-parallel}}}

\item{parallel.version.check}{Logical: If TRUE, check that the version of
\code{\link[=ergm-package]{ergm}} running on the slave nodes is the same as
that running on the master node.}

\item{parallel.inherit.MT}{Logical: If TRUE, slave nodes and
processes inherit the \code{\link[=set.MT_terms]{set.MT_terms()}} setting.}
}
\value{
A list with arguments as components.
}
\description{
Auxiliary function as user interface for fine-tuning simulated annealing
algorithm.
}
\details{
This function is only used within a call to the \code{\link{san}} function.
See the \code{usage} section in \code{\link{san}} for details.
}
\seealso{
\code{\link{san}}
}
\keyword{models}
