% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.ergm.R
\name{control.ergm}
\alias{control.ergm}
\title{Auxiliary for Controlling ERGM Fitting}
\usage{
control.ergm(
  drop = TRUE,
  init = NULL,
  init.method = NULL,
  main.method = c("MCMLE", "Robbins-Monro", "Stochastic-Approximation", "Stepping"),
  force.main = FALSE,
  main.hessian = TRUE,
  checkpoint = NULL,
  resume = NULL,
  MPLE.samplesize = .Machine$integer.max,
  init.MPLE.samplesize = function(d, e) max(sqrt(d), e, 40) * 8,
  MPLE.type = c("glm", "penalized", "logitreg"),
  MPLE.maxit = 10000,
  MPLE.nonvar = c("warning", "message", "error"),
  MPLE.nonident = c("warning", "message", "error"),
  MPLE.nonident.tol = 1e-10,
  MPLE.constraints.ignore = FALSE,
  MCMC.prop = trim_env(~sparse),
  MCMC.prop.weights = "default",
  MCMC.prop.args = list(),
  MCMC.interval = NULL,
  MCMC.burnin = EVL(MCMC.interval * 16),
  MCMC.samplesize = NULL,
  MCMC.effectiveSize = NULL,
  MCMC.effectiveSize.damp = 10,
  MCMC.effectiveSize.maxruns = 16,
  MCMC.effectiveSize.burnin.pval = 0.2,
  MCMC.effectiveSize.burnin.min = 0.05,
  MCMC.effectiveSize.burnin.max = 0.5,
  MCMC.effectiveSize.burnin.nmin = 16,
  MCMC.effectiveSize.burnin.nmax = 128,
  MCMC.effectiveSize.burnin.PC = FALSE,
  MCMC.effectiveSize.burnin.scl = 32,
  MCMC.effectiveSize.order.max = NULL,
  MCMC.return.stats = TRUE,
  MCMC.runtime.traceplot = FALSE,
  MCMC.maxedges = Inf,
  MCMC.addto.se = TRUE,
  MCMC.packagenames = c(),
  SAN.maxit = 4,
  SAN.nsteps.times = 8,
  SAN = control.san(term.options = term.options, SAN.maxit = SAN.maxit,
    SAN.prop.weights = MCMC.prop.weights, SAN.prop.args = MCMC.prop.args, SAN.nsteps =
    EVL(MCMC.burnin, 16384) * SAN.nsteps.times, SAN.samplesize = EVL(MCMC.samplesize,
    1024), SAN.packagenames = MCMC.packagenames, parallel = parallel, parallel.type =
    parallel.type, parallel.version.check = parallel.version.check),
  MCMLE.termination = c("confidence", "Hummel", "Hotelling", "precision", "none"),
  MCMLE.maxit = 60,
  MCMLE.conv.min.pval = 0.5,
  MCMLE.confidence = 0.99,
  MCMLE.confidence.boost = 2,
  MCMLE.confidence.boost.threshold = 1,
  MCMLE.confidence.boost.lag = 4,
  MCMLE.NR.maxit = 100,
  MCMLE.NR.reltol = sqrt(.Machine$double.eps),
  obs.MCMC.mul = 1/4,
  obs.MCMC.samplesize.mul = sqrt(obs.MCMC.mul),
  obs.MCMC.samplesize = EVL(round(MCMC.samplesize * obs.MCMC.samplesize.mul)),
  obs.MCMC.effectiveSize = NVL3(MCMC.effectiveSize, . * obs.MCMC.mul),
  obs.MCMC.interval.mul = sqrt(obs.MCMC.mul),
  obs.MCMC.interval = EVL(round(MCMC.interval * obs.MCMC.interval.mul)),
  obs.MCMC.burnin.mul = sqrt(obs.MCMC.mul),
  obs.MCMC.burnin = EVL(round(MCMC.burnin * obs.MCMC.burnin.mul)),
  obs.MCMC.prop = MCMC.prop,
  obs.MCMC.prop.weights = MCMC.prop.weights,
  obs.MCMC.prop.args = MCMC.prop.args,
  obs.MCMC.impute.min_informative = function(nw) network.size(nw)/4,
  obs.MCMC.impute.default_density = function(nw) 2/network.size(nw),
  MCMLE.min.depfac = 2,
  MCMLE.sampsize.boost.pow = 0.5,
  MCMLE.MCMC.precision = if (startsWith("confidence", MCMLE.termination[1])) 0.1 else
    0.005,
  MCMLE.MCMC.max.ESS.frac = 0.1,
  MCMLE.metric = c("lognormal", "logtaylor", "Median.Likelihood", "EF.Likelihood",
    "naive"),
  MCMLE.method = c("BFGS", "Nelder-Mead"),
  MCMLE.dampening = FALSE,
  MCMLE.dampening.min.ess = 20,
  MCMLE.dampening.level = 0.1,
  MCMLE.steplength.margin = 0.05,
  MCMLE.steplength = NVL2(MCMLE.steplength.margin, 1, 0.5),
  MCMLE.steplength.parallel = c("observational", "never"),
  MCMLE.sequential = TRUE,
  MCMLE.density.guard.min = 10000,
  MCMLE.density.guard = exp(3),
  MCMLE.effectiveSize = 64,
  obs.MCMLE.effectiveSize = NVL3(MCMLE.effectiveSize, . * obs.MCMC.mul),
  MCMLE.interval = 1024,
  MCMLE.burnin = MCMLE.interval * 16,
  MCMLE.samplesize.per_theta = 32,
  MCMLE.samplesize.min = 256,
  MCMLE.samplesize = NULL,
  obs.MCMLE.samplesize.per_theta = round(MCMLE.samplesize.per_theta *
    obs.MCMC.samplesize.mul),
  obs.MCMLE.samplesize.min = 256,
  obs.MCMLE.samplesize = NULL,
  obs.MCMLE.interval = round(MCMLE.interval * obs.MCMC.interval.mul),
  obs.MCMLE.burnin = round(MCMLE.burnin * obs.MCMC.burnin.mul),
  MCMLE.steplength.solver = c("glpk", "lpsolve"),
  MCMLE.last.boost = 4,
  MCMLE.steplength.esteq = TRUE,
  MCMLE.steplength.miss.sample = function(x1) ceiling(sqrt(ncol(rbind(x1)))),
  MCMLE.steplength.min = 1e-04,
  MCMLE.effectiveSize.interval_drop = 2,
  MCMLE.save_intermediates = NULL,
  MCMLE.nonvar = c("message", "warning", "error"),
  MCMLE.nonident = c("warning", "message", "error"),
  MCMLE.nonident.tol = 1e-10,
  SA.phase1_n = NULL,
  SA.initial_gain = NULL,
  SA.nsubphases = 4,
  SA.niterations = NULL,
  SA.phase3_n = NULL,
  SA.interval = 1024,
  SA.burnin = SA.interval * 16,
  SA.samplesize = 1024,
  RM.phase1n_base = 7,
  RM.phase2n_base = 100,
  RM.phase2sub = 7,
  RM.init_gain = 0.5,
  RM.phase3n = 500,
  RM.interval = 1024,
  RM.burnin = RM.interval * 16,
  RM.samplesize = 1024,
  Step.maxit = 50,
  Step.gridsize = 100,
  Step.interval = 1024,
  Step.burnin = Step.interval * 16,
  Step.samplesize = 1024,
  CD.samplesize.per_theta = 128,
  obs.CD.samplesize.per_theta = 128,
  CD.nsteps = 8,
  CD.multiplicity = 1,
  CD.nsteps.obs = 128,
  CD.multiplicity.obs = 1,
  CD.maxit = 60,
  CD.conv.min.pval = 0.5,
  CD.NR.maxit = 100,
  CD.NR.reltol = sqrt(.Machine$double.eps),
  CD.metric = c("naive", "lognormal", "logtaylor", "Median.Likelihood",
    "EF.Likelihood"),
  CD.method = c("BFGS", "Nelder-Mead"),
  CD.dampening = FALSE,
  CD.dampening.min.ess = 20,
  CD.dampening.level = 0.1,
  CD.steplength.margin = 0.5,
  CD.steplength = 1,
  CD.adaptive.epsilon = 0.01,
  CD.steplength.esteq = TRUE,
  CD.steplength.miss.sample = function(x1) ceiling(sqrt(ncol(rbind(x1)))),
  CD.steplength.min = 1e-04,
  CD.steplength.parallel = c("observational", "always", "never"),
  CD.steplength.solver = c("glpk", "lpsolve"),
  loglik = control.logLik.ergm(),
  term.options = NULL,
  seed = NULL,
  parallel = 0,
  parallel.type = NULL,
  parallel.version.check = TRUE,
  parallel.inherit.MT = FALSE,
  ...
)
}
\arguments{
\item{drop}{Logical: If TRUE, terms whose observed statistic values are at
the extremes of their possible ranges are dropped from the fit and their
corresponding parameter estimates are set to plus or minus infinity, as
appropriate.  This is done because maximum likelihood estimates cannot exist
when the vector of observed statistic lies on the boundary of the convex
hull of possible statistic values.}

\item{init}{numeric or \code{NA} vector equal in length to the number of
parameters in the model or \code{NULL} (the default); the initial values for
the estimation and coefficient offset terms. If \code{NULL} is passed, all
of the initial values are computed using the method specified by
\code{\link[=control.ergm]{control$init.method}}.  If a numeric vector is
given, the elements of the vector are interpreted as follows: \itemize{
\item Elements corresponding to terms enclosed in \code{offset()} are used as
the fixed offset coefficients. Note that offset coefficients alone can be
more conveniently specified using \code{\link[=ergm]{ergm()}} argument
\code{offset.coef}. If both \code{offset.coef} and \code{init} arguments are
given, values in \code{offset.coef} will take precedence.

\item Elements that do not correspond to offset terms and are not \code{NA}
are used as starting values in the estimation.

\item Initial values for the elements that are \code{NA} are fit using the
method specified by \code{\link[=control.ergm]{control$init.method}}.

} Passing \code{control.ergm(init=coef(prev.fit))} can be used to
``resume'' an uncoverged \code{\link[=ergm]{ergm()}} run, though \code{checkpoint} and
`resume` would be better under most circumstances.}

\item{init.method}{A chatacter vector or \code{NULL}. The default
method depends on the reference measure used. For the binary
(\code{"Bernoulli"}) ERGMs, with dyad-independent constraints,
it's maximum pseudo-likelihood estimation (MPLE). Other valid
values include \code{"zeros"} for a \code{0} vector of
appropriate length and \code{"CD"} for contrastive divergence. If
passed explicitly, this setting overrides the reference's
limitations.

Valid initial methods for a given reference are set by the \verb{InitErgmReference.*} function.}

\item{main.method}{One of "MCMLE" (default),"Robbins-Monro",
"Stochastic-Approximation", or "Stepping".  Chooses the estimation method
used to find the MLE.  \code{MCMLE} attempts to maximize an approximation to
the log-likelihood function.  \code{Robbins-Monro} and
\code{Stochastic-Approximation} are both stochastic approximation algorithms
that try to solve the method of moments equation that yields the MLE in the
case of an exponential family model.  Another alternative is a partial
stepping algorithm (\code{Stepping}) as in Hummel et al. (2012).  The direct
use of the likelihood function has many theoretical advantages over
stochastic approximation, but the choice will depend on the model and data
being fit. See Handcock (2000) and Hunter and Handcock (2006) for details.

Note that in recent versions of ERGM, the enhancements of \code{Stepping}
have been folded into the default \code{MCMLE}, which is able to handle more
modeling scenarios; and \code{Stepping} may be removed in a future version.}

\item{force.main}{Logical: If TRUE, then force MCMC-based estimation method,
even if the exact MLE can be computed via maximum pseudolikelihood
estimation.}

\item{main.hessian}{Logical: If TRUE, then an approximate Hessian matrix is
used in the MCMC-based estimation method.}

\item{checkpoint}{At the start of every iteration, save the state
of the optimizer in a way that will allow it to be resumed. The
name is passed through \code{\link[=sprintf]{sprintf()}} with iteration number as the
second argument. (For example, \code{checkpoint="step_\%03d.RData"}
will save to \code{step_001.RData}, \code{step_002.RData}, etc.)}

\item{resume}{If given a file name of an \code{RData} file produced by
\code{checkpoint}, the optimizer will attempt to resume after
restoring the state. Control parameters from the saved state will
be reused, except for those whose value passed via
\code{control.ergm()} had change from the saved run. Note that if the
network, the model, or some critical settings differ between
runs, the results may be undefined.}

\item{MPLE.samplesize, init.MPLE.samplesize}{These parameters control the maximum number of dyads (potential
ties) that will be used by the MPLE to construct the predictor
matrix for its logistic regression. In general, the algorithm
visits dyads in a systematic sample that, if it does not hit one
of these limits, will visit every informative dyad. If a limit is
exceeded, case-control approximation to the likelihood,
comprising all edges and those non-edges that have been visited
by the algorithm before the limit was exceeded will be used.

\code{MPLE.samplesize} limits the number of dyads visited, unless the
MPLE is being computed for the purpose of being the initial value
for MCMC-based estimation, in which case \code{init.MPLE.samplesize}
is used instead, All of these can be specified either as numbers or as
\verb{function(d,e)} taking the number of informative dyads and
informative edges. Specifying or returning a larger number than
the number of informative dyads is safe.}

\item{MPLE.type}{One of \code{"glm"}, \code{"penalized"}, or
\code{"logitreg"}.  Chooses method of calculating MPLE.  \code{"glm"} is the
usual formal logistic regression called via \code{\link{glm}}, whereas
\code{"penalized"} uses the bias-reduced method of Firth (1993) as
originally implemented by Meinhard Ploner, Daniela Dunkler, Harry
Southworth, and Georg Heinze in the "logistf" package. \code{"logitreg"} is
an "in-house" implementation that is slower and probably less stable but
supports nonlinear logistic regression. It is invoked automatically when the
model has curved terms.}

\item{MPLE.maxit}{Maximum number of iterations for \code{"logitreg"}
implementation of MPLE.}

\item{MPLE.nonident, MPLE.nonident.tol, MPLE.nonvar, MCMLE.nonident, MCMLE.nonident.tol, MCMLE.nonvar}{A rudimentary nonidentifiability/multicollinearity diagnostic. If
\code{MPLE.nonident.tol > 0}, test the MPLE covariate matrix or the CD
statistics matrix has linearly dependent columns via \link[=qr]{QR decomposition} with tolerance \code{MPLE.nonident.tol}. This is
often (not always) indicative of a non-identifiable
(multicollinear) model. If nonidentifiable, depending on
\code{MPLE.nonident} issue a warning, an error, or a message
specifying the potentially redundant statistics. Before the
diagnostic is performed, covariates that do not vary (i.e.,
all-zero columns) are dropped, with their handling controlled by
\code{MPLE.nonvar}. The corresponding \verb{MCMLE.*} arguments provide a
similar diagnostic for the unconstrained MCMC sample's estimating
functions.}

\item{MPLE.constraints.ignore}{If \code{TRUE}, MPLE will ignore all
dyad-independent constraints except for those due to attributes
missingness. This can be used to avert evaluating and storing the
\code{\link{rlebdm}}s for very large networks except where absolutely
necessary. Note that this can be very dangerous unless you know
what you are doing.}

\item{MCMC.prop}{Specifies the proposal (directly) and/or
a series of "hints" about the structure of the model being
sampled. The specification is in the form of a one-sided formula
with hints separated by \code{+} operations. If the LHS exists and is
a string, the proposal to be used is selected directly.

A common and default "hint" is \code{~sparse}, indicating
that the network is sparse and that the sample should put roughly
equal weight on selecting a dyad with or without a tie as a
candidate for toggling.}

\item{MCMC.prop.weights}{Specifies the proposal
distribution used in the MCMC Metropolis-Hastings algorithm.  Possible
choices depending on selected \code{reference} and \code{constraints}
arguments of the \code{\link[=ergm]{ergm()}} function, but often include \code{"TNT"}
and \code{"random"}, and the \code{"default"} is to use the one with the
highest priority available.}

\item{MCMC.prop.args}{An alternative, direct way of
specifying additional arguments to proposal.}

\item{MCMC.interval}{Number of proposals between sampled statistics.
Increasing interval will reduces the autocorrelation in the sample, and may
increase the precision in estimates by reducing MCMC error, at the expense
of time. Set the interval higher for larger networks.}

\item{MCMC.burnin}{Number of proposals before any MCMC sampling is done. It
typically is set to a fairly large number.}

\item{MCMC.samplesize}{Number of network statistics, randomly drawn from a
given distribution on the set of all networks, returned by the
Metropolis-Hastings algorithm.  Increasing sample size may increase the
precision in the estimates by reducing MCMC error, at the expense of time.
Set it higher for larger networks, or when using parallel functionality.}

\item{MCMC.effectiveSize, MCMC.effectiveSize.damp, MCMC.effectiveSize.maxruns, MCMC.effectiveSize.burnin.pval, MCMC.effectiveSize.burnin.min, MCMC.effectiveSize.burnin.max, MCMC.effectiveSize.burnin.nmin, MCMC.effectiveSize.burnin.nmax, MCMC.effectiveSize.burnin.PC, MCMC.effectiveSize.burnin.scl, MCMC.effectiveSize.order.max}{Set \code{MCMC.effectiveSize} to a non-NULL value to adaptively
determine the burn-in and the MCMC length needed to get the
specified effective size; 50 is a reasonable value. In the
adaptive MCMC mode, MCMC is run forward repeatedly
(\code{MCMC.samplesize*MCMC.interval} steps, up to
\code{MCMC.effectiveSize.maxruns} times) until the target effective
sample size is reached or exceeded.

After each run, the returned statistics are mapped to the
estimating function scale, then an exponential decay model is fit
to the scaled statistics to find that burn-in which would reduce
the difference between the initial values of statistics and their
equilibrium values by a factor of \code{MCMC.effectiveSize.burnin.scl}
of what it initially was, bounded by \code{MCMC.effectiveSize.min} and
\code{MCMC.effectiveSize.max} as proportions of sample size. If the
best-fitting decay exceeds \code{MCMC.effectiveSize.max}, the
exponential model is considered to be unsuitable and
\code{MCMC.effectiveSize.min} is used.

A Geweke diagnostic is then run, after thinning the sample to
\code{MCMC.effectiveSize.burnin.nmax}. If this Geweke diagnostic
produces a \eqn{p}-value higher than
\code{MCMC.effectiveSize.burnin.pval}, it is accepted.

If \code{MCMC.effectiveSize.burnin.PC>0}, instead of using the full
sample for burn-in estimation, at most this many principal
components are used instead.

The effective
size of the post-burn-in sample is computed via Vats, Flegal, and
Jones (2015), and compared to the target effective size. If it is
not matched, the MCMC run is resumed, with the additional draws
needed linearly extrapolated but weighted in favor of the
baseline \code{MCMC.samplesize} by the weighting factor
\code{MCMC.effectiveSize.damp} (higher = less damping). Lastly, if
after an MCMC run, the number of samples equals or exceeds
\code{2*MCMC.samplesize}, the chain will be thinned by 2 until it
falls below that, while doubling
\code{MCMC.interval}. \code{MCMC.effectiveSize.order.max} can be used to
set the order of the AR model used to estimate the effective
sample size and the variance for the Geweke diagnostic.}

\item{MCMC.return.stats}{Logical: If TRUE, return the matrix of MCMC-sampled
network statistics.  This matrix should have \code{MCMC.samplesize} rows.
This matrix can be used directly by the \code{coda} package to assess MCMC
convergence.}

\item{MCMC.runtime.traceplot}{Logical: If \code{TRUE}, plot traceplots of the MCMC
sample after every MCMC MLE iteration.}

\item{MCMC.maxedges}{The maximum number of edges that may occur during the MCMC sampling. If this number is exceeded at any time, sampling is stopped immediately.}

\item{MCMC.addto.se}{Whether to add the standard errors induced by the MCMC
algorithm to the estimates' standard errors.}

\item{MCMC.packagenames}{Names of packages in which to look for change
statistic functions in addition to those autodetected. This argument should
not be needed outside of very strange setups.}

\item{SAN.maxit}{When \code{target.stats} argument is passed to
\code{\link[=ergm]{ergm()}}, the maximum number of attempts to use \code{\link{san}}
to obtain a network with statistics close to those specified.}

\item{SAN.nsteps.times}{Multiplier for \code{SAN.nsteps} relative to
\code{MCMC.burnin}. This lets one control the amount of SAN burn-in
(arguably, the most important of SAN parameters) without overriding the
other \code{SAN} defaults.}

\item{SAN}{Control arguments to \code{\link{san}}.  See
\code{\link{control.san}} for details.}

\item{MCMLE.termination}{The criterion used for terminating MCMLE
estimation:
\itemize{
\item \code{"Hummel"} Terminate when the Hummel step length is
1 for two consecutive iterations. For the last iteration, the sample size is
boosted by a factor of \code{MCMLE.last.boost}. See Hummel et. al. (2012).
}

Note that this criterion is incompatible with \code{MCMLE.steplength}
\eqn{\ne} 1 or \code{MCMLE.steplength.margin} \eqn{=} \code{NULL}.
\itemize{
\item \code{"Hotelling"} After every MCMC sample, an autocorrelation-adjusted
Hotelling's T^2 test for equality of MCMC-simulated network statistics to
observed is conducted, and if its P-value exceeds
\code{MCMLE.conv.min.pval}, the estimation is considered to have converged
and finishes. This was the default option in \code{ergm} version 3.1.
\item \code{"precision"} Terminate when the estimated loss in estimating precision
due to using MCMC standard errors is below the precision bound specified by
\code{MCMLE.MCMC.precision}, and the Hummel step length is 1 for two
consecutive iterations. See \code{MCMLE.MCMC.precision} for details. This
feature is in experimental status until we verify the coverage of the
standard errors.
}

Note that this criterion is incompatible with
\eqn{\code{MCMLE.steplength}\ne 1} or
\eqn{\code{MCMLE.steplength.margin}=\code{NULL}}.
\itemize{
\item \code{"confidence"}: Performs an equivalence test to prove with level
of confidence \code{MCMLE.confidence} that the true value of the
deviation of the simulated mean value parameter from the observed
is within an ellipsoid defined by the inverse-variance-covariance
of the sufficient statistics multiplied by a scaling factor
\code{control$MCMLE.MCMC.precision} (which has a different default).
\item \code{"none"} Stop after
\code{MCMLE.maxit} iterations.
}}

\item{MCMLE.maxit}{Maximum number of times the parameter for the MCMC should
be updated by maximizing the MCMC likelihood. At each step the parameter is
changed to the values that maximizes the MCMC likelihood based on the
current sample.}

\item{MCMLE.conv.min.pval}{The P-value used in the Hotelling test for early
termination.}

\item{MCMLE.confidence}{The confidence level for declaring
convergence for \code{"confidence"} methods.}

\item{MCMLE.confidence.boost}{The maximum increase factor in sample
size (or target effective size, if enabled) when the
\code{"confidence"} termination criterion is either not approaching
the tolerance region or is unable to prove convergence.}

\item{MCMLE.confidence.boost.threshold, MCMLE.confidence.boost.lag}{Sample size or target effective size will be increaed if the distance from the tolerance region fails to decrease more than MCMLE.confidence.boost.threshold in this many successive iterations.}

\item{MCMLE.NR.maxit, MCMLE.NR.reltol}{The method, maximum number of
iterations and relative tolerance to use within the \code{optim} rountine in
the MLE optimization. Note that by default, ergm uses \code{trust}, and
falls back to \code{optim} only when \code{trust} fails.}

\item{obs.MCMC.prop, obs.MCMC.prop.weights, obs.MCMC.prop.args, obs.MCMLE.effectiveSize, obs.MCMC.samplesize, obs.MCMC.burnin, obs.MCMC.interval, obs.MCMC.mul, obs.MCMC.samplesize.mul, obs.MCMC.burnin.mul, obs.MCMC.interval.mul, obs.MCMC.effectiveSize, obs.MCMLE.burnin, obs.MCMLE.interval, obs.MCMLE.samplesize, obs.MCMLE.samplesize.per_theta, obs.MCMLE.samplesize.min}{Corresponding MCMC parameters and settings used for the constrained sample when
unobserved data are present in the estimation routine. By default, they are controlled by the \verb{*.mul}
parameters, as fractions of the corresponding settings for the
unconstrained (standard) MCMC.

These can, in turn, be controlled by \code{obs.MCMC.mul}, which can be
used to set the overal multiplier for the number of MCMC steps in
the constrained sample; one half of its effect applies to the
burn-in and interval and the other half to the total sample
size. For example, for \code{obs.MCMC.mul=1/4} (the default),
\code{obs.MCMC.samplesize} is set to \eqn{\sqrt{1/4}=1/2} that of
\code{obs.MCMC.samplesize}, and \code{obs.MCMC.burnin} and
\code{obs.MCMC.interval} are set to \eqn{\sqrt{1/4}=1/2} of their
respective unconstrained sampling parameters. When
\code{MCMC.effectiveSize} or \code{MCMLE.effectiveSize} are given, their
corresponding \code{obs} parameters are set to them multiplied by
\code{obs.MCMC.mul}.}

\item{obs.MCMC.impute.min_informative, obs.MCMC.impute.default_density}{Controls for imputation of missing dyads for initializing MCMC
sampling. If numeric, \code{obs.MCMC.impute.min_informative} specifies
the minimum number dyads that need to be non-missing before
sample network density is used as the imputation density. It can
also be specified as a function that returns this
value. \code{obs.MCMC.impute.default_density} similarly controls the
imputation density when number of non-missing dyads is too low.}

\item{MCMLE.min.depfac, MCMLE.sampsize.boost.pow}{When using adaptive MCMC effective size, and methods that increase the MCMC sample size, use \code{MCMLE.sampsize.boost.pow} as the power of the boost amount (relative to the boost of the target effective size), but ensure that sample size is no less than \code{MCMLE.min.depfac} times the target effective size.}

\item{MCMLE.MCMC.precision, MCMLE.MCMC.max.ESS.frac}{\code{MCMLE.MCMC.precision} is a vector of upper bounds on the standard
errors induced by the MCMC algorithm, expressed as a percentage of the total
standard error. The MCMLE algorithm will terminate when the MCMC standard
errors are below the precision bound, and the Hummel step length is 1 for
two consecutive iterations. This is an experimental feature.

If effective sample size is used (see \code{MCMC.effectiveSize}), then ergm
may increase the target ESS to reduce the MCMC standard error.}

\item{MCMLE.metric}{Method to calculate the loglikelihood approximation.
See Hummel et al (2010) for an explanation of "lognormal" and "naive".}

\item{MCMLE.method}{Deprecated. By default, ergm uses \code{trust}, and
falls back to \code{optim} with Nelder-Mead method when \code{trust} fails.}

\item{MCMLE.dampening}{(logical) Should likelihood dampening be used?}

\item{MCMLE.dampening.min.ess}{The effective sample size below which
dampening is used.}

\item{MCMLE.dampening.level}{The proportional distance from boundary of the
convex hull move.}

\item{MCMLE.steplength.margin}{The extra margin required for a Hummel step
to count as being inside the convex hull of the sample.  Set this to 0 if
the step length gets stuck at the same value over several iteraions. Set it
to \code{NULL} to use fixed step length. Note that this parameter is
required to be non-\code{NULL} for MCMLE termination using Hummel or
precision criteria.}

\item{MCMLE.steplength}{Multiplier for step length (on the
mean-value parameter scale), which may (for values less than one)
make fitting more stable at the cost of computational efficiency.

If \code{MCMLE.steplength.margin} is not \code{NULL}, the step
length will be set using the algorithm of Hummel et
al. (2010). In that case, it will serve as the maximum step
length considered. However, setting it to anything other than 1
will preclude using Hummel or precision as termination criteria.}

\item{MCMLE.steplength.parallel}{Whether parallel multisection
search (as opposed to a bisection search) for the Hummel step
length should be used if running in multiple threads. Possible
values (partially matched) are \code{"never"}, and
(default) \code{"observational"} (i.e., when missing data MLE is
used).}

\item{MCMLE.sequential}{Logical: If TRUE, the next iteration of the fit uses
the last network sampled as the starting network.  If FALSE, always use the
initially passed network.  The results should be similar (stochastically),
but the TRUE option may help if the \code{target.stats} in the
\code{\link[=ergm]{ergm()}} function are far from the initial network.}

\item{MCMLE.density.guard.min, MCMLE.density.guard}{A simple heuristic to
stop optimization if it finds itself in an overly dense region, which
usually indicates ERGM degeneracy: if the sampler encounters a network
configuration that has more than \code{MCMLE.density.guard.min} edges and
whose number of edges is exceeds the observed network by more than
\code{MCMLE.density.guard}, the optimization process will be stopped with an
error.}

\item{MCMLE.effectiveSize, MCMLE.effectiveSize.interval_drop, MCMLE.burnin, MCMLE.interval, MCMLE.samplesize, MCMLE.samplesize.per_theta, MCMLE.samplesize.min}{Sets the corresponding \verb{MCMC.*} parameters when
\code{main.method="MCMLE"} (the default). Used because defaults may be
different for different methods. \code{MCMLE.samplesize.per_theta}
controls the MCMC sample size (not target effective size) as a
function of the number of (curved) parameters in the model, and
\code{MCMLE.samplesize.min} sets the minimum sample size regardless of
their number.}

\item{MCMLE.steplength.solver}{The linear program solver to use for
MCMLE step length calculation. Can be either \code{"glpk"} to use
\CRANpkg{Rglpk} or \code{"lpsolve"} to use \CRANpkg{lpSolveAPI}.
\CRANpkg{Rglpk} can be orders of magnitude faster, particularly
for models with many parameters and with large sample sizes, so
it is used where available; but it requires an external library
to install under some operating systems, so fallback to
\CRANpkg{lpSolveAPI} provided.}

\item{MCMLE.last.boost}{For the Hummel termination criterion, increase the
MCMC sample size of the last iteration by this factor.}

\item{MCMLE.steplength.esteq}{For curved ERGMs, should the estimating function
values be used to compute the Hummel step length? This allows the Hummel
stepping algorithm converge when some sufficient statistics are at 0.}

\item{MCMLE.steplength.miss.sample}{In fitting the missing data
MLE, the rules for step length become more complicated. In short,
it is necessary for \emph{all} points in the constrained sample
to be in the convex hull of the unconstrained (though they may be
on the border); and it is necessary for their centroid to be in
its interior. This requires checking a large number of points
against whether they are in the convex hull, so to speed up the
procedure, a sample is taken of the points most likely to be
outside it.  This parameter specifies the sample size or a
function of the unconstrained sample matrix to determine the
sample size.}

\item{MCMLE.steplength.min}{Stops MCMLE estimation when the step length gets
stuck below this minimum value.}

\item{MCMLE.save_intermediates}{Every iteration, after MCMC
sampling, save the MCMC sample and some miscellaneous information
to a file with this name. This is mainly useful for diagnostics
and debugging. The name is passed through \code{\link[=sprintf]{sprintf()}} with
iteration number as the second argument. (For example,
\code{MCMLE.save_intermediates="step_\%03d.RData"} will save to
\code{step_001.RData}, \code{step_002.RData}, etc.)}

\item{SA.phase1_n}{Number of MCMC samples to draw in Phase 1 of the
stochastic approximation algorithm.  Defaults to 7 plus 3 times the number
of terms in the model.  See Snijders (2002) for details.}

\item{SA.initial_gain}{Initial gain to Phase 2 of the stochastic
approximation algorithm.  See Snijders (2002) for details.}

\item{SA.nsubphases}{Number of sub-phases in Phase 2 of the stochastic
approximation algorithm.  Defaults to \code{MCMLE.maxit}.  See Snijders
(2002) for details.}

\item{SA.niterations}{Number of MCMC samples to draw in Phase 2 of the
stochastic approximation algorithm.  Defaults to 7 plus the number of terms
in the model.  See Snijders (2002) for details.}

\item{SA.phase3_n}{Sample size for the MCMC sample in Phase 3 of the
stochastic approximation algorithm.  See Snijders (2002) for details.}

\item{SA.burnin, SA.interval, SA.samplesize}{Sets the corresponding
\verb{MCMC.*} parameters when \code{main.method="Stochastic-Approximation"}.}

\item{RM.phase1n_base, RM.phase2n_base, RM.phase2sub, RM.init_gain, RM.phase3n}{The Robbins-Monro control parameters are not yet documented.}

\item{RM.burnin, RM.interval, RM.samplesize}{Sets the corresponding
\verb{MCMC.*} parameters when \code{main.method="Robbins-Monro"}.}

\item{Step.maxit}{Maximum number of iterations (steps) allowed by the
"Stepping" method.}

\item{Step.gridsize}{Integer \eqn{N} such that the "Stepping" style of
optimization chooses a step length equal to the largest possible multiple of
\eqn{1/N}.  See Hummel et al. (2012) for details.}

\item{Step.burnin, Step.interval, Step.samplesize}{Sets the corresponding
\verb{MCMC.*} parameters when \code{main.method="Stepping"}.}

\item{CD.samplesize.per_theta, obs.CD.samplesize.per_theta, CD.maxit, CD.conv.min.pval, CD.NR.maxit, CD.NR.reltol, CD.metric, CD.method, CD.dampening, CD.dampening.min.ess, CD.dampening.level, CD.steplength.margin, CD.steplength, CD.steplength.parallel, CD.adaptive.epsilon, CD.steplength.esteq, CD.steplength.miss.sample, CD.steplength.min, CD.steplength.solver}{Miscellaneous tuning parameters of the CD sampler and
optimizer. These have the same meaning as their \verb{MCMLE.*} and
\verb{MCMC.*} counterparts.

Note that only the Hotelling's stopping criterion is implemented
for CD.}

\item{CD.nsteps, CD.multiplicity}{Main settings for contrastive divergence to
obtain initial values for the estimation: respectively, the number of
Metropolis--Hastings steps to take before reverting to the starting value
and the number of tentative proposals per step. Computational experiments
indicate that increasing \code{CD.multiplicity} improves the estimate faster
than increasing \code{CD.nsteps} --- up to a point --- but it also samples
from the wrong distribution, in the sense that while as
\code{CD.nsteps}\eqn{\rightarrow\infty}, the CD estimate approaches the MLE,
this is not the case for \code{CD.multiplicity}.

In practice, MPLE, when available, usually outperforms CD for even a very
high \code{CD.nsteps} (which is, in turn, not very stable), so CD is useful
primarily when MPLE is not available. This feature is to be considered
experimental and in flux.

The default values have been set experimentally, providing a reasonably
stable, if not great, starting values.}

\item{CD.nsteps.obs, CD.multiplicity.obs}{When there are missing dyads,
\code{CD.nsteps} and \code{CD.multiplicity} must be set to a relatively high
value, as the network passed is not necessarily a good start for CD.
Therefore, these settings are in effect if there are missing dyads in the
observed network, using a higher default number of steps.}

\item{loglik}{See \code{\link{control.ergm.bridge}}}

\item{term.options}{A list of additional arguments to be passed to term initializers. See \code{\link[=term.options]{? term.options}}.}

\item{seed}{Seed value (integer) for the random number generator.  See
\code{\link[base]{set.seed}}.}

\item{parallel}{Number of threads in which to run the sampling. Defaults to
0 (no parallelism). See the entry on \link[=ergm-parallel]{parallel processing}
for details and troubleshooting.}

\item{parallel.type}{API to use for parallel processing. Supported values
are \code{"MPI"} and \code{"PSOCK"}. Defaults to using the \code{parallel}
package with PSOCK clusters. See \code{\link{ergm-parallel}}}

\item{parallel.version.check}{Logical: If TRUE, check that the version of
\code{\link[=ergm-package]{ergm}} running on the slave nodes is the same as
that running on the master node.}

\item{parallel.inherit.MT}{Logical: If TRUE, slave nodes and
processes inherit the \code{\link[=set.MT_terms]{set.MT_terms()}} setting.}

\item{\dots}{A dummy argument to catch deprecated or mistyped control parameters.}
}
\value{
A list with arguments as components.
}
\description{
Auxiliary function as user interface for fine-tuning 'ergm' fitting.
}
\details{
This function is only used within a call to the \code{\link[=ergm]{ergm()}} function.
See the \code{usage} section in \code{\link[=ergm]{ergm()}} for details.
}
\references{
\itemize{
\itemize{
\item Snijders, T.A.B. (2002), Markov Chain Monte
Carlo Estimation of Exponential Random Graph Models.  Journal of Social
Structure.  Available from
\url{https://www.cmu.edu/joss/content/articles/volume3/Snijders.pdf}.
\item Firth (1993), Bias Reduction in Maximum Likelihood Estimates.
Biometrika, 80: 27-38.
\item Hunter, D. R. and M. S. Handcock (2006), Inference in curved
exponential family models for networks. Journal of Computational and
Graphical Statistics, 15: 565-583.
\item Hummel, R. M., Hunter, D. R., and Handcock, M. S. (2012), Improving
Simulation-Based Algorithms for Fitting ERGMs, Journal of Computational and
Graphical Statistics, 21: 920-939.
\item Kristoffer Sahlin. Estimating convergence of Markov chain Monte Carlo
simulations. Master's Thesis. Stockholm University, 2011.
\url{https://www2.math.su.se/matstat/reports/master/2011/rep2/report.pdf}
}

}
}
\seealso{
\code{\link[=ergm]{ergm()}}. The \code{\link{control.simulate}} function
performs a similar function for \code{\link{simulate.ergm}};
\code{\link{control.gof}} performs a similar function for \code{\link{gof}}.
}
\keyword{models}
