% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eratosthenes.R
\name{seq_check}
\alias{seq_check}
\alias{seq_check.list}
\title{Sequence Check}
\usage{
seq_check(obj)

\method{seq_check}{list}(obj)
}
\arguments{
\item{obj}{A \code{list} of \code{vector} objects which reperesent a sequence.}
}
\value{
\code{TRUE} or \code{FALSE}
}
\description{
For a \code{list} of partial sequences (of \code{vector} objects), check to see that joint elements of each occur the same order. That is, for two sequences with elements \eqn{A, B, C, D, E} and \eqn{B, D, F, E}, all joint elements must occur in the same order to pass the check. Two sequences \eqn{A, B, C, D, E} and \eqn{A, F, D, C, E} would not pass this check as the elements \eqn{C} and \eqn{D} occur in different orders in either sequence.
}
\examples{
x <- c("A", "B", "C", "D", "E")
y <- c("B", "D", "F", "E")
a <- list(x, y)

seq_check(a)

z <- c("B", "F", "C")
b <- list(x, y, z)

seq_check(b)

}
