% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RI.R
\name{showRTRICurve}
\alias{showRTRICurve}
\title{Show RT-RI curve}
\usage{
showRTRICurve(
  Experiment,
  reference.list,
  nAnchors = 4,
  ri.thrs = "1R",
  id.database = mslib
)
}
\arguments{
\item{Experiment}{S4 object with experiment Data, Metadata and Results. Results of experiment are used to extract RT and Compound DB Id.}

\item{reference.list}{List with the compounds and their attributes (AlignId...)}

\item{nAnchors}{The desired equivalent number of degrees of freedom for the smooth.spline function}

\item{ri.thrs}{Retention Index treshold given by the user to discrimine bewteen identification results}

\item{id.database}{Name of the preloaded database (mslib by default, the regular db used by erah)}
}
\description{
This function uses RI of mslib database and RT of the identified compounds to discrimine proper compound identification.
}
\details{
See eRah vignette for more details. To open the vignette, execute the following code in R:
vignette("eRahManual", package="erah")
}
\examples{
\dontrun{
The following set erah to determine which indetified compounds are in RI treshold
RTRICurve <- showRTRICurve(ex, list, nAnchors=4, ri.thrs='1R')
}
}
\references{
[1] Xavier Domingo-Almenara, et al., eRah: A Computational Tool Integrating Spectral Deconvolution and Alignment with Quantification and Identification of Metabolites in GC-MS-Based Metabolomics. Analytical Chemistry (2016). DOI: 10.1021/acs.analchem.6b02927
}
\seealso{
\code{\link{computeRIerror}}
}
\author{
Xavier Domingo-Almenara. xavier.domingo@urv.cat
}
