% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{epm-example}
\alias{epm-example}
\alias{tamiasEPM}
\alias{tamiasPolyList}
\alias{tamiasTraits}
\alias{tamiasTree}
\alias{tamiasTreeSet}
\title{Eco Phylo Mapper datasets}
\usage{
tamiasEPM

tamiasPolyList

tamiasTraits

tamiasTree

tamiasTreeSet
}
\description{
Included datasets in \code{epm}
}
\details{
Included north american chipmunk dataset: \cr
tamiasTree is a phylogeny for chipmunks from Zelditch et al. 2017 \cr
tamiasTreeSet is a distribution of 10 phylogenies for chipmunks, extracted
from the mammal tree from Upham et al. 2019
tamiasTraits is a geometric morphometrics dataset of mean values for 
chipmunks from Zelditch et al. 2017 \cr
tamiasPolyList is a set of geographic ranges for chimpunks from IUCN 2021.\cr
tamiasEPM is an \code{epmGrid} object created with \code{\link{createEPMgrid}} 
using these datasets.
}
\references{
Zelditch, M. L., Ye, J., Mitchell, J. S., & Swiderski, D. L.
(2017). Rare ecomorphological convergence on a complex adaptive landscape:
Body size and diet mediate evolution of jaw shape in squirrels (Sciuridae).
Evolution, 1–17. https://doi.org/10.1111/evo.13168 \cr

Upham, N. S., Esselstyn, J. A., & Jetz, W. (2019). Inferring the mammal tree: 
Species-level sets of phylogenies for questions in ecology, evolution, and 
conservation. PLoS Biology, 17(12), e3000494. 
https://doi.org/10.1371/journal.pbio.3000494 \cr

IUCN 2021. The IUCN Red List of Threatened Species. 2021-3. 
\url{https://www.iucnredlist.org}. Downloaded on 17 March 2021.
}
\keyword{datasets}
